*=======================================================================
*
*   WCSLIB - an implementation of the FITS WCS proposal.
*   Copyright (C) 1995, Mark Calabretta
*
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
*
*   This program is distributed in the hope that it will be useful, but
*   WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*   General Public License for more details.
*
*   You should have received a copy of the GNU General Public License
*   along with this library; if not, write to the Free Software
*   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*   Correspondence concerning WCSLIB may be directed to:
*      Internet email: mcalabre@atnf.csiro.au
*      Postal address: Dr. Mark Calabretta,
*                      Australia Telescope National Facility,
*                      P.O. Box 76,
*                      Epping, NSW, 2121,
*                      AUSTRALIA
*
*=======================================================================
      PROGRAM TWCS
*-----------------------------------------------------------------------
*   twcs tests WCSLIB by drawing native and celestial coordinate grids
*   for Bonne's projection.
*
*   $Id: twcs.f,v 1.1 1995/01/31 03:20:39 mcalabre Exp $
*-----------------------------------------------------------------------
      INTEGER   CI, IERR, ILAT, ILNG, J
      REAL      XR(512), YR(512)
      DOUBLE PRECISION CELEST(10), LAT, LNG, NATIVE(10), PRJ(0:20), X, Y
      CHARACTER PCODE*3, TEXT*72
*-----------------------------------------------------------------------
*     Set up Bonne's projection with reference latitude at +30.
      PCODE = 'BON'

*     Initialize the projection array.
      DO 10 J = 0, 11
         PRJ(J) = 0D0
 10   CONTINUE
      PRJ(1) = 30D0

*     Set WCS reference angles for the native grid.
      NATIVE(1) =   0D0
      NATIVE(2) =   0D0
      NATIVE(3) = 180D0
      NATIVE(4) =   0D0

*     For the celestial grid, set the celestial coordinates of the
*     reference point of Bonne's projection (which is at the
*     intersection of the native equator and prime meridian) and the
*     native longitude of the celestial pole.  These correspond to FITS
*     keywords CRVAL1, CRVAL2, and LONGPOLE.
      CELEST(1) = 150D0
      CELEST(2) = -30D0
      CELEST(3) = 150D0
      CELEST(4) =   0D0

*     PGPLOT initialization.
      CALL PGBEG (0, '/xwindow', 1, 1)

*     Define pen colours.
      CALL PGSCR (0, 0.00, 0.00, 0.00)
      CALL PGSCR (1, 1.00, 1.00, 0.00)
      CALL PGSCR (2, 1.00, 1.00, 1.00)
      CALL PGSCR (3, 0.80, 0.50, 0.50)
      CALL PGSCR (4, 0.50, 0.50, 0.80)
      CALL PGSCR (5, 0.80, 0.80, 0.80)
      CALL PGSCR (6, 0.80, 0.50, 0.50)
      CALL PGSCR (7, 0.50, 0.50, 0.80)
      CALL PGSCR (8, 0.30, 0.50, 0.30)

*     Define PGPLOT viewport.
      CALL PGENV (-180.0, 180.0, -90.0, 130.0, 1, -2)

*     Write a descriptive title.
      TEXT = PCODE // ' projection - 15 degree graticule'
      WRITE (6, '(A)') TEXT
      CALL PGTEXT (-180.0, -100.0, TEXT)

      WRITE (TEXT, 20) CELEST(1), CELEST(2)
 20   FORMAT ('centered on celestial coordinates (',F6.2,',',F6.2,')')
      WRITE (6, '(A)') TEXT
      CALL PGTEXT (-180.0, -110.0, TEXT)

      WRITE (TEXT, 30) CELEST(3)
 30   FORMAT ('with north celestial pole at native longitude',F7.2)
      WRITE (6, '(A)') TEXT
      CALL PGTEXT (-180.0, -120.0, TEXT)


*     Draw the native coordinate grid faintly in the background.
      CALL PGSCI (8)

*     Draw native meridians of longitude.
      DO 50 ILNG = -180, 180, 15
         LNG = DBLE(ILNG)
         IF (ILNG.EQ.-180) LNG = -179.99D0

         J = 0
         DO 40 ILAT = 90, -90, -1
            LAT = DBLE(ILAT)

            CALL WCSFWD (PCODE, LNG, LAT, NATIVE, PRJ, X, Y, IERR)
            IF (IERR.NE.0) GO TO 40

            J = J + 1
            XR(J) = -X
            YR(J) =  Y
 40      CONTINUE

         CALL PGLINE (J, XR, YR)
 50   CONTINUE

*     Draw native parallels of latitude.
      DO 70 ILAT = 90, -90, -15
         LAT = DBLE(ILAT)

         J = 0
         DO 60 ILNG = -180, 180, 1
            LNG = DBLE(ILNG)
            IF (ILNG.EQ.-180) LNG = -179.99D0

            CALL WCSFWD (PCODE, LNG, LAT, NATIVE, PRJ, X, Y, IERR)
            IF (IERR.NE.0) GO TO 60

            J = J + 1
            XR(J) = -X
            YR(J) =  Y
 60      CONTINUE

         CALL PGLINE (J, XR, YR)
 70   CONTINUE


*     Draw a colour-coded celestial coordinate grid.
      CI = 1

*     Draw celestial meridians of longitude.
      DO 90 ILNG = -180, 180, 15
         LNG = DBLE(ILNG)

         CI = CI + 1
         IF (CI.GT.7) CI = 2
         IF (ILNG.EQ.0) THEN
            CALL PGSCI (1)
         ELSE
            CALL PGSCI (CI)
         END IF

         J = 0
         DO 80 ILAT = 90, -90, -1
            LAT = DBLE(ILAT)

            CALL WCSFWD (PCODE, LNG, LAT, CELEST, PRJ, X, Y, IERR)
            IF (IERR.NE.0) GO TO 80

*           Test for discontinuities.
            IF (J.GT.0) THEN
               IF (ABS(X+XR(J)).GT.3D0 .OR. ABS(Y-YR(J)).GT.3D0) THEN
                  CALL PGLINE (J, XR, YR)
                  J = 0
               END IF
            END IF

            J = J + 1
            XR(J) = -X
            YR(J) =  Y
 80      CONTINUE

         CALL PGLINE (J, XR, YR)
 90   CONTINUE

*     Draw celestial parallels of latitude.
      CI = 1
      DO 110 ILAT = 90, -90, -15
         LAT = DBLE(ILAT)

         CI = CI + 1
         IF (CI.GT.7) CI = 2
         IF (ILAT.EQ.0) THEN
            CALL PGSCI (1)
         ELSE
            CALL PGSCI (CI)
         END IF

         J = 0
         DO 100 ILNG = -180, 180, 1
            LNG = DBLE(ILNG)

            CALL WCSFWD (PCODE, LNG, LAT, CELEST, PRJ, X, Y, IERR)
            IF (IERR.NE.0) GO TO 100

*           Test for discontinuities.
            IF (J.GT.0) THEN
               IF (ABS(X+XR(J)).GT.3D0 .OR. ABS(Y-YR(J)).GT.3D0) THEN
                  CALL PGLINE (J, XR, YR)
                  J = 0
               END IF
            END IF

            J = J + 1
            XR(J) = -X
            YR(J) =  Y
 100     CONTINUE

         CALL PGLINE (J, XR, YR)
 110  CONTINUE

      CALL PGEND


      END
