*=======================================================================
*
*   WCSLIB - an implementation of the FITS WCS proposal.
*   Copyright (C) 1995,1996 Mark Calabretta
*
*   This library is free software; you can redistribute it and/or
*   modify it under the terms of the GNU Library General Public
*   License as published by the Free Software Foundation; either
*   version 2 of the License, or (at your option) any later version.
*
*   This library is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*   Library General Public License for more details.
*
*   You should have received a copy of the GNU Library General Public
*   License along with this library; if not, write to the Free
*   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*   Correspondence concerning WCSLIB may be directed to:
*      Internet email: mcalabre@atnf.csiro.au
*      Postal address: Dr. Mark Calabretta,
*                      Australia Telescope National Facility,
*                      P.O. Box 76,
*                      Epping, NSW, 2121,
*                      AUSTRALIA
*
*=======================================================================
      PROGRAM TWCS1
*-----------------------------------------------------------------------
*
*   TWCS1 tests WCSFWD and WCSREV for closure on the 1 degree celestial
*   grid for a number of selected projections.
*
*   $Id: twcs1.f,v 2.1 1996/05/07 21:15:04 mcalabre Exp $
*-----------------------------------------------------------------------
*     Set maximum number of axes (MAXIS) and number of axes (NAXIS).
      INTEGER   M, N
      PARAMETER (M = 10, N = 4)

      INTEGER   I, IERR, J
      DOUBLE PRECISION CDELT(M), CRPIX(M), CRVAL(M), CEL0(10), CELC(10),
     *          CELP(10), IMGPIX(M,M), LATC, LIN, MAXIS, NAXIS,
     *          PC(M,M), PIXIMG(M,M), PRJ(0:20)
      CHARACTER CTYPE(M)*8

      DOUBLE PRECISION TOL
      PARAMETER (TOL = 1.0D-10)

      DATA (CTYPE(I), I=1,N)
     *           /'FREQ    ', 'XLAT--xxx', 'TIME    ', 'XLON--xxx'/
      DATA (CRPIX(I), I=1,N)
     *           / 0.0D0,  0.0D0,  0.0D0,  0.0D0/
      DATA ((PC(I,J),I=1,N),J=1,N)
     *           / 1.1D0,    0D0,    0D0,    0D0,
     *               0D0,  1.0D0,    0D0,  0.1D0,
     *               0D0,    0D0,  1.0D0,    0D0,
     *               0D0,  0.2D0,    0D0,  1.0D0/
      DATA (CDELT(I), I=1,N)
     *           / 1.0D0,  1.0D0,  1.0D0, -1.0D0/
      DATA (CRVAL(I), I=1,N)
     *           / 408D6,  0.0D0,   -2D3,  0.0D0/

*     Force alignment.
      COMMON /DUMMY/ LIN, MAXIS, NAXIS, CRPIX, PC, CDELT, PIXIMG, IMGPIX
*-----------------------------------------------------------------------
*     Uncomment the following two lines to raise SIGFPE on floating
*     point exceptions for the Sun FORTRAN compiler.  This signal can
*     be caught within 'dbx' by issuing the command "catch FPE".
*#include <floatingpoint.h>
*     call ieee_handler ('set', 'common', SIGFPE_ABORT)

      WRITE (6, 5)
 5    FORMAT (/,'Testing closure of WCSLIB world coordinate ',
     *          'transformation routines',/,
     *          '-------------------------------------------',
     *          '-----------------------')

      LIN   = 0D0
      MAXIS = DBLE(M)
      NAXIS = DBLE(N)

      DO 10 J = 0, 20
         PRJ(J) = 0D0
 10   CONTINUE

*     Latitude midway between the standard parallels for the conics.
      LATC = 60D0

*     Set reference angles for the celestial grids; polar projections...
      CELP(1) = 150D0
      CELP(2) = -30D0
      CELP(3) = 150D0
      CELP(4) = 999D0

*     Force CELP to be initialized since we want to use it now.
      CELP(5) = 0D0
      CALL CELSET ('ARC', CELP, PRJ, IERR)

*     Compute reference angles for the cylindrical and conic projections
*     so that they all use the same oblique celestial grid regardless of
*     the reference point; conic projections...
      CALL SPHREV (0D0, LATC, CELP(6), CELC(1), CELC(2), IERR)
      CALL SPHFWD (0D0, 90D0, CELP(6), CELC(3), CELC(4), IERR)

*     ...cylindrical and conventional projections.
      CALL SPHREV (0D0,  0D0, CELP(6), CEL0(1), CEL0(2), IERR)
      CALL SPHFWD (0D0, 90D0, CELP(6), CEL0(3), CEL0(4), IERR)

*     Note that we have 3 contexts (CELP, CELC, and CEL0).  WCSEX will
*     force these to be initialized on every invokation since PCODE will
*     differ each time.

*     ARC: zenithal/azimuthal equidistant.
      CTYPE(2)(6:8) = 'ARC'
      CTYPE(4)(6:8) = 'ARC'
      CALL WCSEX (TOL, CTYPE, CRVAL, CELP, PRJ, LIN)

*     ZEA: zenithal/azimuthal equal area.
      CTYPE(2)(6:8) = 'ZEA'
      CTYPE(4)(6:8) = 'ZEA'
      CALL WCSEX (TOL, CTYPE, CRVAL, CELP, PRJ, LIN)

*     CYP: cylindrical perspective.
      CTYPE(2)(6:8) = 'CYP'
      CTYPE(4)(6:8) = 'CYP'
      PRJ(1) = 3D0
      PRJ(2) = 0.8D0
      CALL WCSEX (TOL, CTYPE, CRVAL, CEL0, PRJ, LIN)

*     CAR: Cartesian.
      CTYPE(2)(6:8) = 'CAR'
      CTYPE(4)(6:8) = 'CAR'
      CALL WCSEX (TOL, CTYPE, CRVAL, CEL0, PRJ, LIN)

*     CEA: cylindrical equal area.
      CTYPE(2)(6:8) = 'CEA'
      CTYPE(4)(6:8) = 'CEA'
      PRJ(1) = 0.75D0
      CALL WCSEX (TOL, CTYPE, CRVAL, CEL0, PRJ, LIN)

*     COD: conic equidistant.
      CTYPE(2)(6:8) = 'COD'
      CTYPE(4)(6:8) = 'COD'
      PRJ(1) = LATC
      PRJ(2) = 15D0
      CALL WCSEX (TOL, CTYPE, CRVAL, CELC, PRJ, LIN)

*     COE: conic equal area.
      CTYPE(2)(6:8) = 'COE'
      CTYPE(4)(6:8) = 'COE'
      PRJ(1) = LATC
      PRJ(2) = 15D0
      CALL WCSEX (TOL, CTYPE, CRVAL, CELC, PRJ, LIN)

*     BON: Bonne's projection.
      CTYPE(2)(6:8) = 'BON'
      CTYPE(4)(6:8) = 'BON'
      PRJ(1) = 30D0
      CALL WCSEX (TOL, CTYPE, CRVAL, CEL0, PRJ, LIN)

*     PCO: polyconic.
      CTYPE(2)(6:8) = 'PCO'
      CTYPE(4)(6:8) = 'PCO'
      CALL WCSEX (TOL, CTYPE, CRVAL, CEL0, PRJ, LIN)

*     GLS: Sanson-Flamsteed (global sinusoid).
      CTYPE(2)(6:8) = 'GLS'
      CTYPE(4)(6:8) = 'GLS'
      CALL WCSEX (TOL, CTYPE, CRVAL, CEL0, PRJ, LIN)

*     PAR: parabolic.
      CTYPE(2)(6:8) = 'PAR'
      CTYPE(4)(6:8) = 'PAR'
      CALL WCSEX (TOL, CTYPE, CRVAL, CEL0, PRJ, LIN)

*     AIT: Hammer-Aitoff.
      CTYPE(2)(6:8) = 'AIT'
      CTYPE(4)(6:8) = 'AIT'
      CALL WCSEX (TOL, CTYPE, CRVAL, CEL0, PRJ, LIN)

*     MOL: Mollweide's projection.
      CTYPE(2)(6:8) = 'MOL'
      CTYPE(4)(6:8) = 'MOL'
      CALL WCSEX (TOL, CTYPE, CRVAL, CEL0, PRJ, LIN)

*     QSC: quadrilateralized spherical cube.
      CTYPE(2)(6:8) = 'QSC'
      CTYPE(4)(6:8) = 'QSC'
      CALL WCSEX (TOL, CTYPE, CRVAL, CEL0, PRJ, LIN)

*     TSC: tangential spherical cube.
      CTYPE(1) = 'CUBEFACE'
      CTYPE(2)(6:8) = 'TSC'
      CTYPE(4)(6:8) = 'TSC'
      CALL WCSEX (TOL, CTYPE, CRVAL, CEL0, PRJ, LIN)

      END


      SUBROUTINE WCSEX (TOL, CTYPE, CRVAL, CEL, PRJ, LIN)
*-----------------------------------------------------------------------
*   WCSEX tests closure of WCSFWD and WCSREV.
*
*   Given:
*      TOL      D        Closure tolerance, degrees.
*      CTYPE    C()*8    Coordinate axis types.
*      CRVAL    D()      Coordinate reference values.
*
*   Given and returned:
*      CEL      D(10)    Coordinate transformation parameters.
*      PRJ      D(0:20)  Projection parameters.
*      LIN      D()      Linear transformation parameters.
*-----------------------------------------------------------------------
      INTEGER   IERR, J, LAT, LNG, WCS(0:3)
      DOUBLE PRECISION CEL(10), CRVAL(*), DLAT, DLATMX, DLNG, DLNGMX,
     *          IMG(4), LAT1, LIN(*), LNG1, PHI, PIX(4), PRJ(0:20),
     *          THETA, TOL, WORLD(4)
      CHARACTER CTYPE(*)*8, PCODE*3
*-----------------------------------------------------------------------
      WCS(0)  = 0
      CEL(5)  = 0D0
      PRJ(10) = 0D0
      PRJ(11) = 0D0

      DLNGMX = 0D0
      DLATMX = 0D0

*     Find the projection code.
      CALL WCSSET (NINT(LIN(3)), CTYPE, WCS, IERR)
      PCODE = CTYPE(WCS(1))(6:8)

      WRITE (6, 10) PCODE, TOL
 10   FORMAT (/,'Testing ',A,'; closure tolerance',1PG9.1,' deg.')

      DO 60 LAT = 90, -90, -1
         LAT1 = DBLE(LAT)

         DO 50 LNG = -180, 180
            LNG1 = DBLE(LNG)

            WORLD(1) = 0D0
            WORLD(2) = 0D0
            WORLD(3) = 0D0
            WORLD(4) = 0D0
            WORLD(WCS(1)) = LNG1
            WORLD(WCS(2)) = LAT1

            CALL WCSFWD (CTYPE, WCS, WORLD, CRVAL, CEL, PHI, THETA, PRJ,
     *         IMG, LIN, PIX, IERR)
            IF (IERR.NE.0) THEN
               WRITE (6, 20) PCODE, LNG1, LAT1, IERR
 20            FORMAT (A3,': LNG1 =',F20.15,'  LAT1 =',F20.15,
     *            '  error',I3)
               GO TO 50
            END IF

            CALL WCSREV (CTYPE, WCS, PIX, LIN, IMG, PRJ, PHI, THETA,
     *         CRVAL, CEL, WORLD, IERR)
            IF (IERR.NE.0) THEN
               WRITE (6, 30) PCODE, LNG1, LAT1, IERR
 30            FORMAT (8X,A3,': LNG1 =',F20.15,'  LAT1 =',F20.15,/,
     *                 '  Error',I3)
               GO TO 50
            END IF
 
            DLNG = ABS(WORLD(WCS(1))-LNG1)
            IF (DLNG.GT.180D0) DLNG = ABS(DLNG-360D0)
            IF (ABS(LAT).NE.90 .AND. DLNG.GT.DLNGMX) DLNGMX = DLNG
            DLAT = ABS(WORLD(WCS(2))-LAT1)
            IF (DLAT.GT.DLATMX) DLATMX = DLAT
 
            IF (DLAT.GT.TOL) THEN
               WRITE (6, 40) PCODE, LNG1, LAT1, WORLD(WCS(1)),
     *            WORLD(WCS(1))
 40            FORMAT (8X,A3,': LNG1 =',F20.15,'  LAT1 =',F20.15,/,
     *                 8X,'     LNG2 =',F20.15,'  LAT2 =',F20.15)
            ELSE IF (ABS(LAT).NE.90) THEN
               IF (DLNG.GT.TOL) THEN
                  WRITE (6, 40) PCODE, LNG1, LAT1, WORLD(WCS(1)),
     *               WORLD(WCS(1))
               END IF
            END IF
 50      CONTINUE
 60   CONTINUE
 
      WRITE (6, 70) DLNGMX, DLATMX
 70   FORMAT (13X,'Maximum residual (sky): LNG',1P,G10.3,'   LAT',G10.3)

 
      DO 80 J = 0, 20
         PRJ(J) = 0D0
 80   CONTINUE

      RETURN
      END
