*=======================================================================
*
*   WCSLIB - an implementation of the FITS WCS proposal.
*   Copyright (C) 1995-1999, Mark Calabretta
*
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
*
*   This program is distributed in the hope that it will be useful, but
*   WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*   General Public License for more details.
*
*   You should have received a copy of the GNU General Public License
*   along with this library; if not, write to the Free Software
*   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*   Correspondence concerning WCSLIB may be directed to:
*      Internet email: mcalabre@atnf.csiro.au
*      Postal address: Dr. Mark Calabretta,
*                      Australia Telescope National Facility,
*                      P.O. Box 76,
*                      Epping, NSW, 2121,
*                      AUSTRALIA
*
*=======================================================================
      PROGRAM TSPH
*-----------------------------------------------------------------------
*   TSPH tests the forward and reverse spherical coordinate transfor-
*   mation routines for closure.
*
*   $Id: tsph.f,v 2.4 1999/11/19 02:25:15 mcalabre Exp $
*-----------------------------------------------------------------------
      INTEGER   IERR, J, LAT, LNG
      DOUBLE PRECISION COSLAT, LNG1, LNG2, EUL(5), LAT1, LAT2, PHI,
     *          THETA, TOL, ZETA

      PARAMETER (TOL = 1D-12)

      DOUBLE PRECISION COSD, SIND
*-----------------------------------------------------------------------
*     Uncomment the following two lines to raise SIGFPE on floating
*     point exceptions for the Sun FORTRAN compiler.  This signal can
*     be caught within 'dbx' by issuing the command "catch FPE".
*#include <f77_floatingpoint.h>
*      call ieee_handler ('set', 'common', SIGFPE_ABORT)

      WRITE (6, 5)
 5    FORMAT (/,'Testing closure of WCSLIB coordinate transformation ',
     *          'routines',/,
     *          '----------------------------------------------------',
     *          '--------')

*     Set reference angles.
      EUL(1) =  90D0
      EUL(2) =  30D0
      EUL(3) = -90D0
      WRITE (6, 10) (EUL(J),J=1,3)
 10   FORMAT (/,'Celestial longitude and latitude of the native pole, ',
     *        'and native',/,'longitude of the celestial pole ',
     *        '(degrees):',3F10.4)

      EUL(4) = COSD(EUL(2))
      EUL(5) = SIND(EUL(2))

      WRITE (6, 20) TOL
 20   FORMAT ('Reporting tolerance:',1PG8.1,' degrees of arc.')

      DO 70 LAT = 90, -90, -1
         LAT1 = DBLE(LAT)
         COSLAT = COSD(LAT1)

         DO 60 LNG = -180, 180
            LNG1 = DBLE(LNG)

            CALL SPHFWD (LNG1, LAT1, EUL, PHI, THETA, IERR)
            IF (IERR.NE.0) THEN
               WRITE (6, 30) LNG1, LAT1, IERR
 30            FORMAT ('LNG1 =',F20.15,'  LAT1 =',F20.15,'  Error',I3)
               GO TO 60
            END IF

            CALL SPHREV (PHI, THETA, EUL, LNG2, LAT2, IERR)
            IF (IERR.NE.0) THEN
               WRITE (6, 40) LNG1, LAT1, PHI, THETA, IERR
 40            FORMAT ('LNG1 =',F20.15,'  LAT1 =',F20.15,/,
     *                 ' PHI =',F20.15,' THETA =',F20.15,'  Error',I3)
               GO TO 60
            END IF

            IF (ABS(LAT2-LAT1).GT.TOL) THEN
               WRITE (6, 50) LNG1, LAT1, PHI, THETA, LNG2, LAT2
 50            FORMAT ('Unclosed: LNG1 =',F20.15,'  LAT1 =',F20.15,/,
     *                 '           PHI =',F20.15,' THETA =',F20.15,/,
     *                 '          LNG2 =',F20.15,'  LAT2 =',F20.15)
            ELSE IF (ABS(LNG2-LNG1)*COSLAT.GT.TOL) THEN
               IF (ABS(ABS(LNG2-LNG1)-360D0)*COSLAT.GT.TOL) THEN
                  WRITE (6, 50) LNG1, LAT1, PHI, THETA, LNG2, LAT2
               END IF
            END IF
 60      CONTINUE
 70   CONTINUE


*     Test closure at points close to the pole.
      DO 90 J = -1, 1, 2
         ZETA = 1D0
         LNG1 = -180D0

         DO 80 LAT = 1, 12
            LAT1 = DBLE(J)*(90D0 - ZETA)

            CALL SPHFWD (LNG1, LAT1, EUL, PHI, THETA, IERR)
            IF (IERR.NE.0) THEN
               WRITE (6, 30) LNG1, LAT1, IERR
               GO TO 80
            END IF

            CALL SPHREV (PHI, THETA, EUL, LNG2, LAT2, IERR)
            IF (IERR.NE.0) THEN
               WRITE (6, 40) LNG1, LAT1, PHI, THETA, IERR
               GO TO 80
            END IF

            IF (ABS(LAT2-LAT1).GT.TOL) THEN
               WRITE (6, 50) LNG1, LAT1, PHI, THETA, LNG2, LAT2
            ELSE IF (ABS(LNG2-LNG1)*COSLAT.GT.TOL) THEN
               IF (ABS(ABS(LNG2-LNG1)-360D0)*COSLAT.GT.TOL) THEN
                  WRITE (6, 50) LNG1, LAT1, PHI, THETA, LNG2, LAT2
               END IF
            END IF

            ZETA = ZETA/10D0
            LNG1 = LNG1 + 30D0
 80      CONTINUE
 90   CONTINUE


      END
