*=======================================================================
*
*   WCSLIB - an implementation of the FITS WCS proposal.
*   Copyright (C) 1995-1999, Mark Calabretta
*
*   This library is free software; you can redistribute it and/or
*   modify it under the terms of the GNU Library General Public
*   License as published by the Free Software Foundation; either
*   version 2 of the License, or (at your option) any later version.
*
*   This library is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*   Library General Public License for more details.
*
*   You should have received a copy of the GNU Library General Public
*   License along with this library; if not, write to the Free
*   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*   Correspondence concerning WCSLIB may be directed to:
*      Internet email: mcalabre@atnf.csiro.au
*      Postal address: Dr. Mark Calabretta,
*                      Australia Telescope National Facility,
*                      P.O. Box 76,
*                      Epping, NSW, 2121,
*                      AUSTRALIA
*
*=======================================================================
*   The functions defined herein are trigonometric or inverse
*   trigonometric functions which take or return angular arguments in
*   decimal degrees.  Many FORTRAN compilers supply these as intrinsic
*   functions in which case this module need not be used.
*
*   $Id: wcstrig.f,v 2.2 1999/06/16 00:20:07 mcalabre Exp $
*-----------------------------------------------------------------------

      DOUBLE PRECISION FUNCTION COSD(ANGLE)
      DOUBLE PRECISION ANGLE, RESID

      DOUBLE PRECISION D2R, PI
      PARAMETER (PI = 3.141592653589793238462643D0, D2R = PI/180D0)

      RESID = ABS(MOD(ANGLE,360D0))
      IF (RESID.EQ.0D0) THEN
         COSD = 1D0
      ELSE IF (RESID.EQ.90D0) THEN
         COSD = 0D0
      ELSE IF (RESID.EQ.180D0) THEN
         COSD = -1D0
      ELSE IF (RESID.EQ.270D0) THEN
         COSD = 0D0
      ELSE
         COSD = DCOS(ANGLE*D2R)
      END IF

      RETURN
      END

*-----------------------------------------------------------------------

      DOUBLE PRECISION FUNCTION SIND(ANGLE)
      DOUBLE PRECISION ANGLE, RESID

      DOUBLE PRECISION D2R, PI
      PARAMETER (PI = 3.141592653589793238462643D0, D2R = PI/180D0)

      RESID = MOD(ANGLE-90D0,360D0)
      IF (RESID.EQ.0D0) THEN
         SIND = 1D0
      ELSE IF (RESID.EQ.90D0) THEN
         SIND = 0D0
      ELSE IF (RESID.EQ.180D0) THEN
         SIND = -1D0
      ELSE IF (RESID.EQ.270D0) THEN
         SIND = 0D0
      ELSE
         SIND = DSIN(ANGLE*D2R)
      END IF

      RETURN
      END

*-----------------------------------------------------------------------

      DOUBLE PRECISION FUNCTION TAND(ANGLE)
      DOUBLE PRECISION ANGLE, RESID

      DOUBLE PRECISION D2R, PI
      PARAMETER (PI = 3.141592653589793238462643D0, D2R = PI/180D0)

      RESID = MOD(ANGLE,360D0)
      IF (RESID.EQ.0D0 .OR. ABS(RESID).EQ.180D0) THEN
         TAND = 0D0
      ELSE IF (RESID.EQ.45D0 .OR. RESID.EQ.225D0) THEN
         TAND = 1D0
      ELSE IF (RESID.EQ.-135D0.OR. RESID.EQ.-315D0) THEN
         TAND = -1D0
      ELSE
         TAND = DTAN(ANGLE*D2R)
      END IF

      RETURN
      END

*-----------------------------------------------------------------------

      DOUBLE PRECISION FUNCTION ACOSD(V)
      DOUBLE PRECISION V

      DOUBLE PRECISION PI, R2D
      PARAMETER (PI = 3.141592653589793238462643D0, R2D = 180D0/PI)

      IF (V.EQ.1D0) THEN
         ACOSD = 0D0
      ELSE IF (V.EQ.0D0) THEN
         ACOSD = 90D0
      ELSE IF (V.EQ.-1D0) THEN
         ACOSD = 180D0
      ELSE
         ACOSD = DACOS(V)*R2D
      END IF

      RETURN
      END

*-----------------------------------------------------------------------

      DOUBLE PRECISION FUNCTION ASIND(V)
      DOUBLE PRECISION V

      DOUBLE PRECISION PI, R2D
      PARAMETER (PI = 3.141592653589793238462643D0, R2D = 180D0/PI)

      IF (V.EQ.-1D0) THEN
         ASIND = -90D0
      ELSE IF (V.EQ.0D0) THEN
         ASIND = 0D0
      ELSE IF (V.EQ.1D0) THEN
         ASIND = 90D0
      ELSE
         ASIND = DASIN(V)*R2D
      END IF

      RETURN
      END

*-----------------------------------------------------------------------

      DOUBLE PRECISION FUNCTION ATAND(V)
      DOUBLE PRECISION V

      DOUBLE PRECISION PI, R2D
      PARAMETER (PI = 3.141592653589793238462643D0, R2D = 180D0/PI)

      IF (V.EQ.-1D0) THEN
         ATAND = -45D0
      ELSE IF (V.EQ.0D0) THEN
         ATAND = 0D0
      ELSE IF (V.EQ.1D0) THEN
         ATAND = 45D0
      ELSE
         ATAND = DATAN(V)*R2D
      END IF

      RETURN
      END

*-----------------------------------------------------------------------

      DOUBLE PRECISION FUNCTION ATAN2D(Y, X)
      DOUBLE PRECISION X, Y

      DOUBLE PRECISION PI, R2D
      PARAMETER (PI = 3.141592653589793238462643D0, R2D = 180D0/PI)

      IF (Y.EQ.0D0) THEN
         IF (X.GE.0D0) THEN
            ATAN2D = 0D0
         ELSE IF (X.LT.0D0) THEN
            ATAN2D = 180D0
         END IF
      ELSE IF (X.EQ.0D0) THEN
         IF (Y.GT.0D0) THEN
            ATAN2D = 90D0
         ELSE IF (Y.LT.0D0) THEN
            ATAN2D = -90D0
         END IF
      ELSE
         ATAN2D = DATAN2(Y,X)*R2D
      END IF

      RETURN
      END
