*=======================================================================
*
*   WCSLIB - an implementation of the FITS WCS proposal.
*   Copyright (C) 1995-2000, Mark Calabretta
*
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
*
*   This program is distributed in the hope that it will be useful, but
*   WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*   General Public License for more details.
*
*   You should have received a copy of the GNU General Public License
*   along with this library; if not, write to the Free Software
*   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*   Correspondence concerning WCSLIB may be directed to:
*      Internet email: mcalabre@atnf.csiro.au
*      Postal address: Dr. Mark Calabretta,
*                      Australia Telescope National Facility,
*                      P.O. Box 76,
*                      Epping, NSW, 2121,
*                      AUSTRALIA
*
*=======================================================================
      PROGRAM TCEL
*-----------------------------------------------------------------------
*   tcel tests the spherical projection driver routines supplied with
*   WCSLIB by drawing native and celestial coordinate grids for Bonne's
*   projection.
*
*   $Id: tcel.f,v 2.4 2000/05/10 04:51:30 mcalabre Exp $
*-----------------------------------------------------------------------
      INTEGER   CI, CRVAL1, CRVAL2, IERR, ILAT, ILNG, J, LATPOL, LNGPOL
      REAL      XR(512), YR(512)
      DOUBLE PRECISION CELEST(10), LAT, LNG, NATIVE(10), PHI, PRJ(0:20),
     *          THETA, X, Y
      CHARACTER PCODE*3, TEXT*72
*-----------------------------------------------------------------------
      WRITE (6, 5)
 5    FORMAT (/,'Testing WCSLIB celestial coordinate transformation ',
     *          'routines',/,
     *          '---------------------------------------------------',
     *          '--------')

*     Set up Bonne's projection with conformal latitude at +35.
      PCODE = 'BON'

*     Initialize the projection array.
      DO 10 J = 0, 11
         PRJ(J) = 0D0
 10   CONTINUE
      PRJ(1) = 35D0

*     Set reference angles for the native grid.
      NATIVE(1) =   0D0
      NATIVE(2) =   0D0
      NATIVE(3) = 999D0
      NATIVE(4) = 999D0
      NATIVE(5) =   0D0

*     PGPLOT initialization.
      CALL PGBEG (0, '/xwindow', 1, 1)

*     Define pen colours.
      CALL PGSCR (0, 0.00, 0.00, 0.00)
      CALL PGSCR (1, 1.00, 1.00, 0.00)
      CALL PGSCR (2, 1.00, 1.00, 1.00)
      CALL PGSCR (3, 0.50, 0.50, 0.80)
      CALL PGSCR (4, 0.80, 0.50, 0.50)
      CALL PGSCR (5, 0.80, 0.80, 0.80)
      CALL PGSCR (6, 0.50, 0.50, 0.80)
      CALL PGSCR (7, 0.80, 0.50, 0.50)
      CALL PGSCR (8, 0.30, 0.50, 0.30)

*     Define PGPLOT viewport.
      CALL PGENV (-180.0, 180.0, -90.0, 140.0, 1, -2)

*     Loop over CRVAL1, CRVAL2, LONGPOLE and LATPOLE.
      CRVAL1 = -180
      DO 140 CRVAL2 = -90, 90, 45
         DO 130 LNGPOL = -180, 180, 15
            DO 120 LATPOL = -1, 1, 2
*              For the celestial grid, set the celestial coordinates of
*              the reference point of the projection (which for Bonne's
*              projection is at the intersection of the native equator
*              and prime meridian), the native longitude of the
*              celestial pole, and extra information needed to determine
*              the native latitude of the celestial pole.  These
*              correspond to FITS keywords CRVAL1, CRVAL2, LONGPOLE, and
*              LATPOLE.
               CELEST(1) = DBLE(CRVAL1)
               CELEST(2) = DBLE(CRVAL2)
               CELEST(3) = DBLE(LNGPOL)
               CELEST(4) = DBLE(LATPOL)
               CELEST(5) = 0D0

*              Skip invalid values of LONGPOLE.
               CALL CELSET (PCODE, CELEST, PRJ, IERR)
               IF (IERR.NE.0) GO TO 120

*              Skip redundant values of LATPOLE.
               IF (LATPOL.EQ.1 .AND. ABS(CELEST(4)).LT.0.1D0) GO TO 120

*              Write a descriptive title.
               TEXT = PCODE // ' projection - 15 degree graticule'
               WRITE (6, '(/,A)') TEXT
               CALL PGTEXT (-180.0, -100.0, TEXT)

               WRITE (TEXT, 20) CELEST(1), CELEST(2)
 20            FORMAT ('centered on celestial coordinates (',F7.2,
     *                 ',', F6.2,')')
               WRITE (6, '(A)') TEXT
               CALL PGTEXT (-180.0, -110.0, TEXT)

               WRITE (TEXT, 30) CELEST(3), CELEST(4)
 30            FORMAT ('with north celestial pole at native ',
     *            'coordinates (',F7.2,',',F7.2,')')
               WRITE (6, '(A)') TEXT
               CALL PGTEXT (-180.0, -120.0, TEXT)


*              Draw native coordinate grid faintly in the background.
               CALL PGSCI (8)

*              Draw native meridians of longitude.
               DO 50 ILNG = -180, 180, 15
                  LNG = DBLE(ILNG)
                  IF (ILNG.EQ.-180) LNG = -179.99D0
                  IF (ILNG.EQ.+180) LNG = +179.99D0

*                 Dash the longitude of the celestial pole.
                  IF (MOD(ILNG-LNGPOL,360).EQ.0) THEN
                     CALL PGSLS (2)
                     CALL PGSLW (5)
                  END IF

                  J = 0
                  DO 40 ILAT = -90, 90
                     LAT = DBLE(ILAT)

                     CALL CELFWD (PCODE, LNG, LAT, NATIVE, PHI, THETA,
     *                  PRJ, X, Y, IERR)
                     IF (IERR.NE.0) GO TO 40

                     J = J + 1
                     XR(J) = -X
                     YR(J) =  Y
 40               CONTINUE

                  CALL PGLINE (J, XR, YR)
                  CALL PGSLS (1)
                  CALL PGSLW (1)
 50            CONTINUE

*              Draw native parallels of latitude.
               DO 70 ILAT = -90, 90, 15
                  LAT = DBLE(ILAT)

                  J = 0
                  DO 60 ILNG = -180, 180
                     LNG = DBLE(ILNG)
                     IF (ILNG.EQ.-180) LNG = -179.99D0
                     IF (ILNG.EQ.+180) LNG = +179.99D0

                     CALL CELFWD (PCODE, LNG, LAT, NATIVE, PHI, THETA,
     *                  PRJ, X, Y, IERR)
                     IF (IERR.NE.0) GO TO 60

                     J = J + 1
                     XR(J) = -X
                     YR(J) =  Y
 60               CONTINUE

                  CALL PGLINE (J, XR, YR)
 70            CONTINUE


*              Draw a colour-coded celestial coordinate grid.
               CI = 1

*              Draw celestial meridians of longitude.
               DO 90 ILNG = -180, 180, 15
                  LNG = DBLE(ILNG)

                  CI = CI + 1
                  IF (CI.GT.7) CI = 2
                  IF (ILNG.EQ.0) THEN
                     CALL PGSCI (1)
                  ELSE
                     CALL PGSCI (CI)
                  END IF

*                 Dash the reference longitude.
                  IF (MOD(ILNG-CRVAL1,360).EQ.0) THEN
                     CALL PGSLS (2)
                     CALL PGSLW (5)
                  END IF

                  J = 0
                  DO 80 ILAT = -90, 90
                     LAT = DBLE(ILAT)

                     CALL CELFWD (PCODE, LNG, LAT, CELEST, PHI, THETA,
     *                  PRJ, X, Y, IERR)
                     IF (IERR.NE.0) GO TO 80

*                    Test for discontinuities.
                     IF (J.GT.0) THEN
                        IF (ABS(X+XR(J)).GT.4D0 .OR.
     *                      ABS(Y-YR(J)).GT.4D0) THEN
                           CALL PGLINE (J, XR, YR)
                           J = 0
                        END IF
                     END IF

                     J = J + 1
                     XR(J) = -X
                     YR(J) =  Y
 80               CONTINUE

                  CALL PGLINE (J, XR, YR)
                  CALL PGSLS (1)
                  CALL PGSLW (1)
 90            CONTINUE

*              Draw celestial parallels of latitude.
               CI = 1
               DO 110 ILAT = -90, 90, 15
                  LAT = DBLE(ILAT)

                  CI = CI + 1
                  IF (CI.GT.7) CI = 2
                  IF (ILAT.EQ.0) THEN
                     CALL PGSCI (1)
                  ELSE
                     CALL PGSCI (CI)
                  END IF

*                 Dash the reference latitude.
                  IF (ILAT.EQ.CRVAL2) THEN
                     CALL PGSLS (2)
                     CALL PGSLW (5)
                  END IF

                  J = 0
                  DO 100 ILNG = -180, 180
                     LNG = DBLE(ILNG)

                     CALL CELFWD (PCODE, LNG, LAT, CELEST, PHI, THETA,
     *                  PRJ, X, Y, IERR)
                     IF (IERR.NE.0) GO TO 100

*                    Test for discontinuities.
                     IF (J.GT.0) THEN
                        IF (ABS(X+XR(J)).GT.4D0 .OR.
     *                      ABS(Y-YR(J)).GT.4D0) THEN
                           CALL PGLINE (J, XR, YR)
                           J = 0
                        END IF
                     END IF

                     J = J + 1
                     XR(J) = -X
                     YR(J) =  Y
 100              CONTINUE

                  CALL PGLINE (J, XR, YR)
                  CALL PGSLS (1)
                  CALL PGSLW (1)
 110           CONTINUE

*              New page.
               CALL PGPAGE ()

*              Cycle through celestial longitudes.
               CRVAL1 = CRVAL1 + 15
               IF (CRVAL1.GT.180) CRVAL1 = -180

*              Skip boring celestial latitudes.
               IF (CRVAL2.EQ.0) GO TO 140
 120        CONTINUE
 130     CONTINUE
 140  CONTINUE

      CALL PGEND


      END
