*=======================================================================
*
*   WCSLIB - an implementation of the FITS WCS proposal.
*   Copyright (C) 1995-2000, Mark Calabretta
*
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
*
*   This program is distributed in the hope that it will be useful, but
*   WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*   General Public License for more details.
*
*   You should have received a copy of the GNU General Public License
*   along with this library; if not, write to the Free Software
*   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*   Correspondence concerning WCSLIB may be directed to:
*      Internet email: mcalabre@atnf.csiro.au
*      Postal address: Dr. Mark Calabretta,
*                      Australia Telescope National Facility,
*                      P.O. Box 76,
*                      Epping, NSW, 2121,
*                      AUSTRALIA
*
*=======================================================================
      PROGRAM TPROJ2
*-----------------------------------------------------------------------
*   TPROJ2 tests projection routines by plotting test grids using
*   PGPLOT.
*
*   $Id: tproj2.f,v 2.7 2000/05/10 04:51:30 mcalabre Exp $
*-----------------------------------------------------------------------
      INTEGER   J
      DOUBLE PRECISION PRJ(0:20)

      DOUBLE PRECISION PI
      PARAMETER (PI = 3.141592653589793238462643D0)

      EXTERNAL AZPFWD
      EXTERNAL TANFWD
      EXTERNAL SINFWD
      EXTERNAL STGFWD
      EXTERNAL ARCFWD
      EXTERNAL ZPNFWD
      EXTERNAL ZEAFWD
      EXTERNAL AIRFWD
      EXTERNAL CYPFWD
      EXTERNAL CARFWD
      EXTERNAL MERFWD
      EXTERNAL CEAFWD
      EXTERNAL COPFWD
      EXTERNAL CODFWD
      EXTERNAL COEFWD
      EXTERNAL COOFWD
      EXTERNAL BONFWD
      EXTERNAL PCOFWD
      EXTERNAL GLSFWD
      EXTERNAL PARFWD
      EXTERNAL AITFWD
      EXTERNAL MOLFWD
      EXTERNAL CSCFWD
      EXTERNAL QSCFWD
      EXTERNAL TSCFWD
*-----------------------------------------------------------------------
      WRITE (6, 5)
 5    FORMAT ('Testing WCSLIB spherical projection routines',/,
     *        '--------------------------------------------')

      DO 10 J = 1, 20
         PRJ(J) = 0D0
 10   CONTINUE

 20   FORMAT(/,A,' projection')
 30   FORMAT(/,A,' projection',/,'Parameters:',5F12.5,/,5F12.5)

*     PGPLOT initialization.
      CALL PGBEG (0, '/xwindow', 1, 1)

*     Define pen colours.
      CALL PGSCR (0, 0.00, 0.00, 0.00)
      CALL PGSCR (1, 1.00, 1.00, 0.00)
      CALL PGSCR (2, 1.00, 1.00, 1.00)
      CALL PGSCR (3, 0.50, 0.50, 0.80)
      CALL PGSCR (4, 0.80, 0.50, 0.50)
      CALL PGSCR (5, 0.80, 0.80, 0.80)
      CALL PGSCR (6, 0.50, 0.50, 0.80)
      CALL PGSCR (7, 0.80, 0.50, 0.50)
      CALL PGSCR (8, 0.30, 0.50, 0.30)

*     AZP: zenithal/azimuthal perspective.
      PRJ(1) = 2D0
      WRITE (6, 30) 'Zenithal/azimuthal perspective', PRJ(1)
      CALL PRJPLT ('AZP', AZPFWD, PRJ, 90, -30, 1)

*     TAN: gnomonic.
      WRITE (6, 20) 'Gnomonic'
      CALL PRJPLT ('TAN', TANFWD, PRJ, 90, 5, 1)

*     SIN: orthographic.
      PRJ(1) = 0.3D0
      PRJ(2) = 0.5D0
      WRITE (6, 30) 'Orthographic/synthesis', (PRJ(J), J=1,2)
      CALL PRJPLT ('SIN', SINFWD, PRJ, 90, -90, 1)

*     STG: stereographic.
      WRITE (6, 20) 'Stereographic'
      CALL PRJPLT ('STG', STGFWD, PRJ, 90, -85, 1)

*     ARC: zenithal/azimuthal equidistant.
      WRITE (6, 20) 'Zenithal/azimuthal equidistant'
      CALL PRJPLT ('ARC', ARCFWD, PRJ, 90, -90, 1)

*     ZPN: zenithal/azimuthal polynomial.
      PRJ(0) =  0.05000D0
      PRJ(1) =  0.95000D0
      PRJ(2) = -0.02500D0
      PRJ(3) = -0.15833D0
      PRJ(4) =  0.00208D0
      PRJ(5) =  0.00792D0
      PRJ(6) = -0.00007D0
      PRJ(7) = -0.00019D0
      PRJ(8) =  0.00000D0
      PRJ(9) =  0.00000D0
      WRITE (6, 30) 'Zenithal/azimuthal polynomial', (PRJ(J), J=0,9)
      CALL PRJPLT ('ZPN', ZPNFWD, PRJ, 90, 10, 1)

*     ZEA: zenithal/azimuthal equal area.
      WRITE (6, 20) 'Zenithal/azimuthal equal area'
      CALL PRJPLT ('ZEA', ZEAFWD, PRJ, 90, -90, 1)

*     AIR: Airy's zenithal projection.
      PRJ(1) = 45D0
      WRITE (6, 30) 'Airy''s zenithal', PRJ(1)
      CALL PRJPLT ('AIR', AIRFWD, PRJ, 90, -85, 1)

*     CYP: cylindrical perspective.
      PRJ(1) = 3.0D0
      PRJ(2) = 0.8D0
      WRITE (6, 30) 'Cylindrical perspective', (PRJ(J), J=1,2)
      CALL PRJPLT ('CYP', CYPFWD, PRJ, 90, -90, 2)

*     CAR: Cartesian.
      WRITE (6, 20) 'Cartesian'
      CALL PRJPLT ('CAR', CARFWD, PRJ, 90, -90, 2)

*     MER: Mercator's.
      WRITE (6, 20) 'Mercator''s'
      CALL PRJPLT ('MER', MERFWD, PRJ, 85, -85, 2)

*     CEA: cylindrical equal area.
      PRJ(1) = 0.75D0
      WRITE (6, 30) 'Cylindrical equal area', PRJ(1)
      CALL PRJPLT ('CEA', CEAFWD, PRJ, 90, -90, 2)

*     COP: conic perspective.
      PRJ(1) =  60D0
      PRJ(2) =  15D0
      WRITE (6, 30) 'Conic perspective', (PRJ(J), J=1,2)
      CALL PRJPLT ('COP', COPFWD, PRJ, 90, -25, 3)

*     COD: conic equidistant.
      PRJ(1) = -60D0
      PRJ(2) =  15D0
      WRITE (6, 30) 'Conic equidistant', (PRJ(J), J=1,2)
      CALL PRJPLT ('COD', CODFWD, PRJ, 90, -90, 3)

*     COE: conic equal area.
      PRJ(1) =  60D0
      PRJ(2) = -15D0
      WRITE (6, 30) 'Conic equal area', (PRJ(J), J=1,2)
      CALL PRJPLT ('COE', COEFWD, PRJ, 90, -90, 3)

*     COO: conic orthomorphic.
      PRJ(1) = -60D0
      PRJ(2) = -15D0
      WRITE (6, 30) 'Conic orthomorphic', (PRJ(J), J=1,2)
      CALL PRJPLT ('COO', COOFWD, PRJ, 85, -90, 3)

*     BON: Bonne's projection.
      PRJ(1) = 30D0
      WRITE (6, 30) 'Bonne''s', PRJ(1)
      CALL PRJPLT ('BON', BONFWD, PRJ, 90, -90, 4)

*     PCO: polyconic.
      WRITE (6, 20) 'Polyconic'
      CALL PRJPLT ('PCO', PCOFWD, PRJ, 90, -90, 4)

*     GLS: Sanson-Flamsteed (global sinusoid).
      WRITE (6, 20) 'Sanson-Flamsteed (global sinusoid)'
      CALL PRJPLT ('GLS', GLSFWD, PRJ, 90, -90, 4)

*     PAR: parabolic.
      WRITE (6, 20) 'Parabolic'
      CALL PRJPLT ('PAR', PARFWD, PRJ, 90, -90, 4)

*     AIT: Hammer-Aitoff.
      WRITE (6, 20) 'Hammer-Aitoff'
      CALL PRJPLT ('AIT', AITFWD, PRJ, 90, -90, 4)

*     MOL: Mollweide's projection.
      WRITE (6, 20) 'Mollweide''s'
      CALL PRJPLT ('MOL', MOLFWD, PRJ, 90, -90, 4)

*     CSC: COBE quadrilateralized spherical cube.
      WRITE (6, 20) 'COBE quadrilateralized spherical cube'
      CALL PRJPLT ('CSC', CSCFWD, PRJ, 90, -90, 5)

*     QSC: quadrilateralized spherical cube.
      WRITE (6, 20) 'Quadrilateralized spherical cube'
      CALL PRJPLT ('QSC', QSCFWD, PRJ, 90, -90, 5)

*     TSC: tangential spherical cube.
      WRITE (6, 20) 'Tangential spherical cube'
      CALL PRJPLT ('TSC', TSCFWD, PRJ, 90, -90, 5)

      CALL PGEND

      END


      SUBROUTINE PRJPLT (PCODE, PRJFWD, PRJ, NORTH, SOUTH, TYPE)
*-----------------------------------------------------------------------
*   PRJPLT draws a 15 degree coordinate grid.
*
*   Given:
*      PCODE    C*3      Projection code.
*      PRJFWD   E        Forward projection routine.
*      NORTH    I        Northern cutoff latitude, degrees.
*      SOUTH    I        Southern cutoff latitude, degrees.
*      TYPE     I        Projection classification:
*                           1: zenithal/azimuthal
*                           2: cylindrical
*                           3: conic
*                           4: conventional
*                           5: quad cube
*
*   Given and returned:
*      PRJ      D(0:20)  Projection parameters.
*-----------------------------------------------------------------------
      INTEGER   CI, IERR, ILAT, ILNG, J, NORTH, SOUTH, TYPE
      REAL      XR(512), YR(512)
      DOUBLE PRECISION LAT, LNG, PRJ(0:20), X, Y
      CHARACTER PCODE*3

      EXTERNAL PRJFWD
*-----------------------------------------------------------------------
      WRITE (6, 10) PCODE, NORTH, SOUTH
 10   FORMAT ('Plotting ',A3,'; Latitudes',I3,' to',I4,'.')

      DO 20 J = 11, 20
         PRJ(J) = 0D0
 20   CONTINUE

      IF (TYPE.EQ.5) THEN
         CALL PGENV (-335.0, 65.0, -200.0, 200.0, 1, -2)
         CALL PGSCI (2)
         CALL PGTEXT (-340.0, -220.0, PCODE//' - 15 degree graticule')

         CALL PGSCI (8)
         CALL PRJFWD (0D0, 0D0, PRJ, X, Y, IERR)

         XR(1) =  PRJ(12)
         YR(1) =  PRJ(12)
         XR(2) =  PRJ(12)
         YR(2) =  PRJ(12)*3.0
         XR(3) = -PRJ(12)
         YR(3) =  PRJ(12)*3.0
         XR(4) = -PRJ(12)
         YR(4) = -PRJ(12)*3.0
         XR(5) =  PRJ(12)
         YR(5) = -PRJ(12)*3.0
         XR(6) =  PRJ(12)
         YR(6) =  PRJ(12)
         XR(7) = -PRJ(12)*7.0
         YR(7) =  PRJ(12)
         XR(8) = -PRJ(12)*7.0
         YR(8) = -PRJ(12)
         XR(9) =  PRJ(12)
         YR(9) = -PRJ(12)
         CALL PGLINE (9, XR, YR)
      ELSE
         CALL PGENV (-200.0, 200.0, -200.0, 200.0, 1, -2)
         CALL PGSCI (2)
         CALL PGTEXT (-240.0, -220.0, PCODE//' - 15 degree graticule')
      END IF


      CI = 1
      DO 40 ILNG = -180, 180, 15
         CI = CI + 1
         IF (CI.GT.7) CI = 2

         LNG = DBLE(ILNG)

         IF (ILNG.EQ.0) THEN
            CALL PGSCI (1)
         ELSE
            CALL PGSCI (CI)
         END IF

         J = 0
         DO 30 ILAT = NORTH, SOUTH, -1
            LAT = DBLE(ILAT)

            CALL PRJFWD (LNG, LAT, PRJ, X, Y, IERR)
            IF (IERR.NE.0) THEN
               IF (J.GT.1) CALL PGLINE (J, XR, YR)
               J = 0
               GO TO 30
            END IF

            IF (TYPE.EQ.5 .AND. J.GT.0) THEN
               IF (ABS(X+XR(J)).GT.2D0 .OR. ABS(Y-YR(J)).GT.5D0) THEN
                  IF (J.GT.1) CALL PGLINE (J, XR, YR)
                  J = 0
               END IF
            END IF

            J = J + 1
            XR(J) = -X
            YR(J) =  Y
 30      CONTINUE

         CALL PGLINE (J, XR, YR)
 40   CONTINUE

      CI = 1
      DO 60 ILAT = -90, 90, 15
         CI = CI + 1
         IF (CI.GT.7) CI = 2

         IF (ILAT.GT.NORTH) GO TO 60
         IF (ILAT.LT.SOUTH) GO TO 60

         LAT = DBLE(ILAT)

         IF (ILAT.EQ.0) THEN
            CALL PGSCI (1)
         ELSE
            CALL PGSCI (CI)
         END IF

         J = 0
         DO 50 ILNG = -180, 180, 1
            LNG = DBLE(ILNG)

            CALL PRJFWD (LNG, LAT, PRJ, X, Y, IERR)
            IF (IERR.NE.0) THEN
               IF (J.GT.1) CALL PGLINE (J, XR, YR)
               J = 0
               GO TO 50
            END IF

            IF (TYPE.EQ.5 .AND. J.GT.0) THEN
               IF (ABS(X+XR(J)).GT.2D0 .OR. ABS(Y-YR(J)).GT.5D0) THEN
                  IF (J.GT.1) CALL PGLINE (J, XR, YR)
                  J = 0
               END IF
            END IF

            J = J + 1
            XR(J) = -X
            YR(J) =  Y
 50      CONTINUE

         CALL PGLINE (J, XR, YR)
 60   CONTINUE

      CALL PGSCI(1)
      XR(1) = 0.0
      YR(1) = 0.0
      CALL PGPT (1, XR, YR, 21)


      DO 80 J = 0, 20
         PRJ(J) = 0D0
 80   CONTINUE

      RETURN
      END
