*=======================================================================
*
*   WCSLIB - an implementation of the FITS WCS proposal.
*   Copyright (C) 1995-2000, Mark Calabretta
*
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
*
*   This program is distributed in the hope that it will be useful, but
*   WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*   General Public License for more details.
*
*   You should have received a copy of the GNU General Public License
*   along with this library; if not, write to the Free Software
*   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*   Correspondence concerning WCSLIB may be directed to:
*      Internet email: mcalabre@atnf.csiro.au
*      Postal address: Dr. Mark Calabretta,
*                      Australia Telescope National Facility,
*                      P.O. Box 76,
*                      Epping, NSW, 2121,
*                      AUSTRALIA
*
*=======================================================================
      PROGRAM TLIN
*-----------------------------------------------------------------------
*
*   TLIN tests the linear transformation routines supplied with WCSLIB.
*
*   $Id: tlin.f,v 2.6 2000/05/10 04:51:30 mcalabre Exp $
*-----------------------------------------------------------------------
*     Set maximum number of axes (MAXIS) and number of axes (NAXIS).
      INTEGER   M, N
      PARAMETER (M = 10, N = 5)

*     Force alignment.
      COMMON /DUMMY/ LIN, MAXIS, NAXIS, CRPIX, PC, CDELT, PIXIMG, IMGPIX

      INTEGER   I, IERR, J
      DOUBLE PRECISION CDELT(M), CRPIX(M), IMG(M), IMGPIX(M,M), LIN,
     *          MAXIS, NAXIS, PC(M,M), PIX(M), PIXIMG(M,M)

      DATA (CRPIX(I), I=1,N)
     *           /256D0, 256D0,  64D0, 128D0,   1D0/
      DATA ((PC(I,J),I=1,N),J=1,N)
     *           /  1.0D0,   0.5D0,   0D0,   0D0,   0D0,
     *              0.5D0,   1.0D0,   0D0,   0D0,   0D0,
     *              0.0D0,   0.0D0,   1D0,   0D0,   0D0,
     *              0.0D0,   0.0D0,   0D0,   1D0,   0D0,
     *              0.0D0,   0.0D0,   0D0,   0D0,   1D0/
      DATA (CDELT(I), I=1,N)
     *           /  1.2D0,   2.3D0,   3.4D0,   4.5D0,   5.6D0/
      DATA (PIX(I), I=1,N)
     *           /303.0D0, 265.0D0, 112.4D0, 144.5D0,  28.2D0/
*-----------------------------------------------------------------------
*     Uncomment the following two lines to raise SIGFPE on floating
*     point exceptions for the Sun FORTRAN compiler.  This signal can
*     be caught within 'dbx' by issuing the command "catch FPE".
*#include <f77_floatingpoint.h>
*     call ieee_handler ('set', 'common', SIGFPE_ABORT)

      WRITE (6, 10)
 10   FORMAT (/,'Testing WCSLIB linear transformation routines',/,
     *          '---------------------------------------------')

      LIN   = 0D0
      MAXIS = DBLE(M)
      NAXIS = DBLE(N)

      WRITE (6, 20) (PIX(J),J=1,N)
 20   FORMAT ('PIX:',10F14.8)

      CALL LINREV (PIX, LIN, IMG, IERR)
      IF (IERR.NE.0) THEN
         WRITE (6, 30) IERR
 30      FORMAT ('LINREV ERROR',I3)
         GO TO 999
      END IF

      WRITE (6, 40) (IMG(J),J=1,N)
 40   FORMAT ('IMG:',10F14.8)

      CALL LINFWD (IMG, LIN, PIX, IERR)
      IF (IERR.NE.0) THEN
         WRITE (6, 50) IERR
 50      FORMAT ('LINFWD ERROR',I3)
         GO TO 999
      END IF

      WRITE (6, 60) (PIX(J),J=1,N)
 60   FORMAT ('PIX:',10F14.8)

      CALL LINREV (PIX, LIN, IMG, IERR)
      IF (IERR.NE.0) THEN
         WRITE (6, 30) IERR
         GO TO 999
      END IF

      WRITE (6, 40) (IMG(J),J=1,N)

 999  END
