*=======================================================================
*
*   WCSLIB - an implementation of the FITS WCS proposal.
*   Copyright (C) 1995-2001, Mark Calabretta
*
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
*
*   This program is distributed in the hope that it will be useful, but
*   WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*   General Public License for more details.
*
*   You should have received a copy of the GNU General Public License
*   along with this library; if not, write to the Free Software
*   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*   Correspondence concerning WCSLIB may be directed to:
*      Internet email: mcalabre@atnf.csiro.au
*      Postal address: Dr. Mark Calabretta,
*                      Australia Telescope National Facility,
*                      P.O. Box 76,
*                      Epping, NSW, 2121,
*                      AUSTRALIA
*
*=======================================================================
      PROGRAM TPROJ1
*-----------------------------------------------------------------------
*   TPROJ1 tests forward and reverse spherical projections for closure.
*
*   $Id: tproj1.f,v 2.9 2001/11/16 03:53:59 mcalabre Exp $
*-----------------------------------------------------------------------
      INTEGER   J
      DOUBLE PRECISION PRJ(0:20)

      DOUBLE PRECISION PI
      PARAMETER (PI = 3.141592653589793238462643D0)

      DOUBLE PRECISION TOL
      PARAMETER (TOL = 1.0D-9)
*-----------------------------------------------------------------------
*     Uncomment the following two lines to raise SIGFPE on floating
*     point exceptions for the Sun FORTRAN compiler.  This signal can
*     be caught within 'dbx' by issuing the command "catch FPE".
*#include <f77_floatingpoint.h>
*      call ieee_handler ('set', 'common', SIGFPE_ABORT)

      WRITE (6, 5)
 5    FORMAT (/,'Testing closure of WCSLIB spherical projection ',
     *          'routines',/,
     *          '-----------------------------------------------',
     *          '--------')

      DO 10 J = 1, 20
         PRJ(J) = 0D0
 10   CONTINUE

*     AZP: zenithal/azimuthal perspective.
      PRJ(1) = 0.5D0
      PRJ(2) =  30D0
      CALL PROJEX ('AZP', PRJ, 90,   5, TOL)

*     SZP: slant zenithal perspective.
      PRJ(1) = 0.5D0
      PRJ(2) = 210D0
      PRJ(3) =  60D0
      CALL PROJEX ('SZP', PRJ, 90, -90, TOL)

*     TAN: gnomonic.
      CALL PROJEX ('TAN', PRJ, 90,   5, TOL)

*     STG: stereographic.
      CALL PROJEX ('STG', PRJ, 90, -85, TOL)

*     SIN: orthographic/synthesis.
      PRJ(1) = -0.3D0
      PRJ(2) =  0.5D0
      CALL PROJEX ('SIN', PRJ, 90,  45, TOL)

*     ARC: zenithal/azimuthal equidistant.
      CALL PROJEX ('ARC', PRJ, 90, -90, TOL)

*     ZPN: zenithal/azimuthal polynomial.
      PRJ(0) =  0.00000D0
      PRJ(1) =  0.95000D0
      PRJ(2) = -0.02500D0
      PRJ(3) = -0.15833D0
      PRJ(4) =  0.00208D0
      PRJ(5) =  0.00792D0
      PRJ(6) = -0.00007D0
      PRJ(7) = -0.00019D0
      PRJ(8) =  0.00000D0
      PRJ(9) =  0.00000D0
      CALL PROJEX ('ZPN', PRJ, 90,  10, TOL)

*     ZEA: zenithal/azimuthal equal area.
      CALL PROJEX ('ZEA', PRJ, 90, -85, TOL)

*     AIR: Airy's zenithal projection.
      PRJ(1) = 45D0
      CALL PROJEX ('AIR', PRJ, 90, -85, TOL)

*     CYP: cylindrical perspective.
      PRJ(1) = 3.0D0
      PRJ(2) = 0.8D0
      CALL PROJEX ('CYP', PRJ, 90, -90, TOL)

*     CEA: cylindrical equal area.
      PRJ(1) = 0.75D0
      CALL PROJEX ('CEA', PRJ, 90, -90, TOL)

*     CAR: Cartesian.
      CALL PROJEX ('CAR', PRJ, 90, -90, TOL)

*     MER: Mercator's.
      CALL PROJEX ('MER', PRJ, 85, -85, TOL)

*     SFL: Sanson-Flamsteed.
      CALL PROJEX ('SFL', PRJ, 90, -90, TOL)

*     PAR: parabolic.
      CALL PROJEX ('PAR', PRJ, 90, -90, TOL)

*     MOL: Mollweide's projection.
      CALL PROJEX ('MOL', PRJ, 90, -90, TOL)

*     AIT: Hammer-Aitoff.
      CALL PROJEX ('AIT', PRJ, 90, -90, TOL)

*     COP: conic perspective.
      PRJ(1) =  60D0
      PRJ(2) =  15D0
      CALL PROJEX ('COP', PRJ, 90, -25, TOL)

*     COE: conic equal area.
      PRJ(1) =  60D0
      PRJ(2) = -15D0
      CALL PROJEX ('COE', PRJ, 90, -90, TOL)

*     COD: conic equidistant.
      PRJ(1) = -60D0
      PRJ(2) =  15D0
      CALL PROJEX ('COD', PRJ, 90, -90, TOL)

*     COO: conic orthomorphic.
      PRJ(1) = -60D0
      PRJ(2) = -15D0
      CALL PROJEX ('COO', PRJ, 85, -90, TOL)

*     BON: Bonne's projection.
      PRJ(1) = 30D0
      CALL PROJEX ('BON', PRJ, 90, -90, TOL)

*     PCO: polyconic.
      CALL PROJEX ('PCO', PRJ, 90, -90, TOL)

*     TSC: tangential spherical cube.
      CALL PROJEX ('TSC', PRJ, 90, -90, TOL)

*     CSC: COBE quadrilateralized spherical cube.
      CALL PROJEX ('CSC', PRJ, 90, -90, 4.0D-2)

*     QSC: quadrilateralized spherical cube.
      CALL PROJEX ('QSC', PRJ, 90, -90, TOL)

      END


      SUBROUTINE PROJEX (PCODE, PRJ, NORTH, SOUTH, TOL)
*-----------------------------------------------------------------------
*   PROJEX exercises the spherical projection routines.
*
*   Given:
*      PCODE    C*3      Projection code.
*      NORTH    I        Northern cutoff latitude, degrees.
*      SOUTH    I        Southern cutoff latitude, degrees.
*      TOL      D        Reporting tolerance, degrees.
*
*   Given and returned:
*      PRJ      D(0:20)  Projection parameters.
*-----------------------------------------------------------------------
      INTEGER   IERR, J, LAT, LNG, NORTH, SOUTH
      DOUBLE PRECISION DLAT, DLATMX, DLNG, DLNGMX, DR, DRMAX, LAT1,
     *           LAT2, LNG1, LNG2, PHI0, PRJ(0:20), R, THETA, THETA0,
     *           TOL, X, X1, X2, Y, Y1, Y2
      CHARACTER PCODE*3

      DOUBLE PRECISION PI
      PARAMETER (PI = 3.141592653589793238462643D0)

      DOUBLE PRECISION COSD, SIND
*-----------------------------------------------------------------------
      DO 10 J = 11, 20
         PRJ(J) = 0D0
 10   CONTINUE

*     Uncomment the next line to test alternative initializations of
*     projection parameters.
*     PRJ(10) = 180D0/PI

      CALL PRJSET (PCODE, PRJ, PHI0, THETA0, IERR)

      WRITE (6, 20) PCODE, NORTH, SOUTH, TOL
 20   FORMAT ('Testing ',A3,'; Latitudes',I3,' to',I4,
     *        ', reporting tolerance',1PG8.1,' deg.')

      DLNGMX = 0D0
      DLATMX = 0D0

      DO 70 LAT = NORTH, SOUTH, -1
         LAT1 = DBLE(LAT)
         DO 60 LNG = -180, 180
            LNG1 = DBLE(LNG)

            CALL PRJFWD (LNG1, LAT1, PRJ, X, Y, IERR)
            IF (IERR.NE.0) THEN
               IF (IERR.NE.2) THEN
                  WRITE (6, 30) PCODE, LNG1, LAT1, IERR
 30               FORMAT (8X,A3,':  LNG =',F20.15,'   LAT =',F20.15,
     *                    '  Error',I3)
               END IF
               GO TO 60
            END IF

            CALL PRJREV (X, Y, PRJ, LNG2, LAT2, IERR)
            IF (IERR.NE.0) THEN
               WRITE (6, 40) PCODE, LNG1, LAT1, X, Y, IERR
 40            FORMAT (8X,A3,': LNG1 =',F20.15,'  LAT1 =',F20.15,/,
     *                 8X,'        X =',F20.15,'     Y =',F20.15,
     *                 '  Error',I3)
               GO TO 60
            END IF

            DLNG = ABS(LNG2-LNG1)
            IF (DLNG.GT.180D0) DLNG = ABS(DLNG-360D0)
            IF (ABS(LAT).NE.90 .AND. DLNG.GT.DLNGMX) DLNGMX = DLNG
            DLAT = ABS(LAT2-LAT1)
            IF (DLAT.GT.DLATMX) DLATMX = DLAT

            IF (DLAT.GT.TOL) THEN
               WRITE (6, 50) PCODE, LNG1, LAT1, X, Y, LNG2, LAT2
 50            FORMAT (8X,A3,': LNG1 =',F20.15,'  LAT1 =',F20.15,/,
     *                 8X,'        X =',F20.15,'     Y =',F20.15,/,
     *                 8X,'     LNG2 =',F20.15,'  LAT2 =',F20.15)
            ELSE IF (ABS(LAT).NE.90) THEN
               IF (DLNG.GT.TOL) THEN
                  WRITE (6, 50) PCODE, LNG1, LAT1, X, Y, LNG2, LAT2
               END IF
            END IF
 60      CONTINUE
 70   CONTINUE

      WRITE (6, 80) DLNGMX, DLATMX
 80   FORMAT (13X,'Maximum residual (sky): LNG',1P,G10.3,'   LAT',G10.3)


*     Test closure at points close to the reference point.
      R = 1.0
      THETA = -180D0

      DRMAX = 0D0

      DO 130 J = 1, 12
         X1 = R*COSD(THETA)
         Y1 = R*SIND(THETA)

         CALL PRJREV (X1, Y1, PRJ, LNG1, LAT1, IERR)
         IF (IERR.NE.0) THEN
            WRITE (6, 90) PCODE, X1, Y1, IERR
 90         FORMAT (8X,A3,':   X1 =',F20.15,'    Y1 =',F20.15,'  Error',
     *              I3)
            GO TO 120
         END IF

         CALL PRJFWD (LNG1, LAT1, PRJ, X2, Y2, IERR)
         IF (IERR.NE.0) THEN
            WRITE (6, 100) PCODE, X1, Y1, LNG1, LAT1, IERR
 100        FORMAT (8X,A3,':   X1 =',F20.15,'    Y1 =',F20.15,/,
     *              8X,'      LNG =',F20.15,'   LAT =',F20.15,'  Error',
     *              I3)
            GO TO 120
         END IF

         DR = SQRT((X2-X1)*(X2-X1) + (Y2-Y1)*(Y2-Y1))
         IF (DR.GT.DRMAX) DRMAX = DR
         IF (DR.GT.TOL) THEN
            WRITE (6, 110) PCODE, X1, Y1, LNG1, LAT1, X2, Y2
 110        FORMAT (8X,A3,':   X1 =',F20.15,'    Y1 =',F20.15,/,
     *              8X,'      LNG =',F20.15,'   LAT =',F20.15,/,
     *              8X,'       X2 =',F20.15,'    Y2 =',F20.15)
         END IF

 120     R = R/10D0
         THETA = THETA + 15D0
 130  CONTINUE

      WRITE (6, 140) DRMAX
 140  FORMAT (13X,'Maximum residual (ref):  dR',1P,G10.3)


      DO 150 J = 0, 20
         PRJ(J) = 0D0
 150  CONTINUE

      RETURN
      END
