/*============================================================================
*
*   WCSLIB - an implementation of the FITS WCS proposal.
*   Copyright (C) 1995-2002, Mark Calabretta
*
*   This program is free software; you can redistribute it and/or modify it
*   under the terms of the GNU General Public License as published by the
*   Free Software Foundation; either version 2 of the License, or (at your
*   option) any later version.
*
*   This program is distributed in the hope that it will be useful, but
*   WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*   General Public License for more details.
*
*   You should have received a copy of the GNU General Public License along
*   with this library; if not, write to the Free Software Foundation, Inc.,
*   675 Mass Ave, Cambridge, MA 02139, USA.
*
*   Correspondence concerning WCSLIB may be directed to:
*      Internet email: mcalabre@atnf.csiro.au
*      Postal address: Dr. Mark Calabretta,
*                      Australia Telescope National Facility,
*                      P.O. Box 76,
*                      Epping, NSW, 2121,
*                      AUSTRALIA
*
*=============================================================================
*
*   twcsprt tests wcsprt() which prints the contents of a wcsprm struct.
*
*   $Id$
*---------------------------------------------------------------------------*/

#include <string.h>
#include <wcs.h>

#ifndef __STDC__
#ifndef const
#define const
#endif
#endif


/* In real life these would be encoded as FITS header cards. */
const int NAXIS = 4;
const double CRPIX[4] =  {  513.0,  0.0,  0.0,  0.0};
const double PC[4][4] = {{    1.1,  0.0,  0.0,  0.0},
                         {    0.0,  1.0,  0.0,  0.1},
                         {    0.0,  0.0,  1.0,  0.0},
                         {    0.0,  0.2,  0.0,  1.0}};
const double CDELT[4] =  {-9.635265432e-6,  1.0,  1.0, -1.0};

				/* The "xxx" is reset in main(). */
char CTYPE[4][9] = {"WAVE-F2W", "XLAT-xxx", "TIME    ", "XLON-xxx"};

const double CRVAL[4] =  {0.214982042, -30.0, -2e3, 150.0};
const double LONPOLE  = 150.0;
const double LATPOLE  = 999.0;
const double RESTFRQ  =   1.42040575e9;
const double RESTWAV  =   0.0;

int NPV;
struct pvcard PV[10];		/* Projection parameters are set in main(). */


int main()

{
   register int i, j;
   struct wcsprm wcs;
   double *pcij;

   /* SZP: slant zenithal perspective. */
   strncpy(&CTYPE[1][5], "SZP", 3);
   strncpy(&CTYPE[3][5], "SZP", 3);

   /* Set the PVi_m cards for the latitude axes.               */
   PV[0].i = 2;			/* Latitude is on axis 2.      */
   PV[0].m = 1;			/* Parameter number 1.         */
   PV[0].value = 2.0;		/* PVi_1.                      */

   PV[1].i = 2;			/* Latitude is on axis 2.      */
   PV[1].m = 2;			/* Parameter number 2.         */
   PV[1].value = 210.0;		/* PVi_2.                      */

   PV[2].i = 2;			/* Latitude is on axis 2.      */
   PV[2].m = 3;			/* Parameter number 3.         */
   PV[2].value = 60.0;		/* PVi_3.                      */

   NPV = 3;

   wcsini(1, 1, NAXIS, &wcs);

   for (j = 0; j < NAXIS; j++) {
      wcs.crpix[j] = CRPIX[j];
   }

   pcij = wcs.pc;
   for (i = 0; i < NAXIS; i++) {
      for (j = 0; j < NAXIS; j++) {
         *(pcij++) = PC[i][j];
      }
   }

   for (i = 0; i < NAXIS; i++) {
      wcs.cdelt[i] = CDELT[i];
   }

   for (i = 0; i < NAXIS; i++) {
      strcpy(wcs.ctype[i], &CTYPE[i][0]);
   }

   for (i = 0; i < NAXIS; i++) {
      wcs.crval[i] = CRVAL[i];
   }

   wcs.lonpole = LONPOLE;
   wcs.latpole = LATPOLE;

   wcs.restfrq = RESTFRQ;
   wcs.restwav = RESTWAV;

   wcs.npv = NPV;
   for (i = 0; i < NPV; i++) {
      wcs.pv[i] = PV[i];
   }

   /* Extract information from the FITS header. */
   (void) wcsset(&wcs);

   printf("\nContents of wcsprm struct:\n");
   wcsprt(&wcs);

   return 0;
}
