/*============================================================================
*
*   WCSLIB 3.0 - an implementation of the FITS WCS convention.
*   Copyright (C) 1995-2003, Mark Calabretta
*
*   This program is free software; you can redistribute it and/or modify it
*   under the terms of the GNU General Public License as published by the
*   Free Software Foundation; either version 2 of the License, or (at your
*   option) any later version.
*
*   This program is distributed in the hope that it will be useful, but
*   WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*   General Public License for more details.
*
*   You should have received a copy of the GNU General Public License along
*   with this library; if not, write to the Free Software Foundation, Inc.,
*   675 Mass Ave, Cambridge, MA 02139, USA.
*
*   Correspondence concerning WCSLIB may be directed to:
*      Internet email: mcalabre@atnf.csiro.au
*      Postal address: Dr. Mark Calabretta
*                      Australia Telescope National Facility, CSIRO
*                      PO Box 76
*                      Epping NSW 1710
*                      AUSTRALIA
*
*=============================================================================
*
*   tlin tests the linear transformation routines supplied with WCSLIB.
*
*   $Id: tlin.c,v 3.0 2003/04/01 04:16:39 mcalabre Exp $
*---------------------------------------------------------------------------*/

#include <stdlib.h>
#include <stdio.h>

#include <lin.h>

int NAXIS  = 5;
int NCOORD = 2;
int NELEM  = 9;

double CRPIX[5] =  {256.0, 256.0,  64.0, 128.0,   1.0};
double PC[5][5] = {{  1.0,   0.5,   0.0,   0.0,   0.0},
                   {  0.5,   1.0,   0.0,   0.0,   0.0},
                   {  0.0,   0.0,   1.0,   0.0,   0.0},
                   {  0.0,   0.0,   0.0,   1.0,   0.0},
                   {  0.0,   0.0,   0.0,   0.0,   1.0}};
double CDELT[5] =  {  1.2,   2.3,   3.4,   4.5,   5.6};

double pix[2][9] = {{303.0, 265.0, 112.4, 144.5,  28.2, 0.0, 0.0, 0.0, 0.0},
                    { 19.0,  57.0,   2.0,  15.0,  42.0, 0.0, 0.0, 0.0, 0.0}};
double img[2][9];

int main()

{
   int i, j, k, status;
   double *pcij;
   struct linprm lin;


   printf("\nTesting WCSLIB linear transformation routines\n");
   printf("---------------------------------------------\n");

   /* List error messages. */
   printf("\nList of linini error codes:\n");
   for (j = 1; j <= 1 ; j++) {
      printf("   %d: %s.\n", j, linini_errmsg[j]);
   }

   printf("\nList of lincpy error codes:\n");
   for (j = 1; j <= 1 ; j++) {
      printf("   %d: %s.\n", j, lincpy_errmsg[j]);
   }

   printf("\nList of linset error codes:\n");
   for (j = 1; j <= 2 ; j++) {
      printf("   %d: %s.\n", j, linset_errmsg[j]);
   }

   printf("\nList of linp2x error codes:\n");
   for (j = 1; j <= 2 ; j++) {
      printf("   %d: %s.\n", j, linp2x_errmsg[j]);
   }

   printf("\nList of linx2p error codes:\n");
   for (j = 1; j <= 2 ; j++) {
      printf("   %d: %s.\n", j, linx2p_errmsg[j]);
   }

   linini(1, NAXIS, &lin);

   for (j = 0; j < lin.naxis; j++) {
      lin.crpix[j] = CRPIX[j];
   }

   pcij = lin.pc;
   for (i = 0; i < lin.naxis; i++) {
      for (j = 0; j < lin.naxis; j++) {
         *(pcij++) = PC[i][j];
      }
   }

   for (i = 0; i < lin.naxis; i++) {
      lin.cdelt[i] = CDELT[i];
   }


   for (k = 0; k < NCOORD; k++) {
      printf("\nPIX %d:", k+1);
      for (j = 0; j < NAXIS; j++) {
         printf("%14.8f", pix[k][j]);
      }
   }
   printf("\n");

   if (status = linp2x(&lin, NCOORD, NELEM, pix[0], img[0])) {
      printf("linp2x error %d\n", status);
      return 1;
   }

   for (k = 0; k < NCOORD; k++) {
      printf("\nIMG %d:", k+1);
      for (j = 0; j < NAXIS; j++) {
         printf("%14.8f", img[k][j]);
      }
   }
   printf("\n");

   if (status = linx2p(&lin, NCOORD, NELEM, img[0], pix[0])) {
      printf("linx2p error %d\n", status);
      return 1;
   }

   for (k = 0; k < NCOORD; k++) {
      printf("\nPIX %d:", k+1);
      for (j = 0; j < NAXIS; j++) {
         printf("%14.8f", pix[k][j]);
      }
   }
   printf("\n");

   if (status = linp2x(&lin, NCOORD, NELEM, pix[0], img[0])) {
      printf("linp2x error %d\n", status);
      return 1;
   }

   for (k = 0; k < NCOORD; k++) {
      printf("\nIMG %d:", k+1);
      for (j = 0; j < NAXIS; j++) {
         printf("%14.8f", img[k][j]);
      }
   }
   printf("\n");

   linfree(&lin);

   return 0;
}
