/*============================================================================
*
*   WCSLIB 3.0 - an implementation of the FITS WCS convention.
*   Copyright (C) 1995-2003, Mark Calabretta
*
*   This library is free software; you can redistribute it and/or modify it
*   under the terms of the GNU Library General Public License as published
*   by the Free Software Foundation; either version 2 of the License, or (at
*   your option) any later version.
*
*   This library is distributed in the hope that it will be useful, but
*   WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library
*   General Public License for more details.
*
*   You should have received a copy of the GNU Library General Public License
*   along with this library; if not, write to the Free Software Foundation,
*   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*   Correspondence concerning WCSLIB may be directed to:
*      Internet email: mcalabre@atnf.csiro.au
*      Postal address: Dr. Mark Calabretta
*                      Australia Telescope National Facility, CSIRO
*                      PO Box 76
*                      Epping NSW 1710
*                      AUSTRALIA
*
*   Author: Mark Calabretta, Australia Telescope National Facility
*   $Id: cel_f.c,v 3.0 2003/04/01 05:19:47 mcalabre Exp $
*===========================================================================*/

#include <cel.h>

#define CEL_FLAG   100
#define CEL_OFFSET 101
#define CEL_PHI0   102
#define CEL_THETA0 103
#define CEL_REF    104
#define CEL_PRJ    105

#define CEL_EULER  200
#define CEL_ISOLAT 201

/*--------------------------------------------------------------------------*/

int celini_(cel)

int *cel;

{
   return celini((struct celprm *)cel);
}

/*--------------------------------------------------------------------------*/

int celput_(cel, what, value, i)

int *cel;
const int *what;
const void *value;
const int *i;

{
   int k;
   const int *ivalp;
   const double *dvalp;
   struct celprm *celp;

   /* Cast pointers. */
   celp  = (struct celprm *)cel;
   ivalp = (const int *)value;
   dvalp = (const double *)value;

   switch (*what) {
   case CEL_FLAG:
      celp->flag = *ivalp;
      break;
   case CEL_OFFSET:
      celp->offset = *ivalp;
      break;
   case CEL_PHI0:
      celp->phi0 = *dvalp;
      break;
   case CEL_THETA0:
      celp->theta0 = *dvalp;
      break;
   case CEL_REF:
      celp->ref[*i-1] = *dvalp;
      break;
   case CEL_PRJ:
      for (k = 14; k < 126; k++) {
         cel[k] = *(ivalp++);
      }
      break;
   default:
      return 1;
   }

   return 0;
}

/*--------------------------------------------------------------------------*/

int celget_(cel, what, value)

const int *cel;
const int *what;
void *value;

{
   int k;
   int *ivalp;
   double *dvalp;
   const struct celprm *celp;

   /* Cast pointers. */
   celp  = (const struct celprm *)cel;
   ivalp = (int *)value;
   dvalp = (double *)value;

   switch (*what) {
   case CEL_FLAG:
      *ivalp = celp->flag;
      break;
   case CEL_OFFSET:
      *ivalp = celp->offset;
      break;
   case CEL_PHI0:
      *dvalp = celp->phi0;
      break;
   case CEL_THETA0:
      *dvalp = celp->theta0;
      break;
   case CEL_REF:
      for (k = 0; k < 4; k++) {
         *(dvalp++) = celp->ref[k];
      }
      break;
   case CEL_PRJ:
      for (k = 14; k < 126; k++) {
         *(ivalp++) = cel[k];
      }
      break;
   case CEL_EULER:
      for (k = 0; k < 5; k++) {
         *(dvalp++) = celp->euler[k];
      }
      break;
   case CEL_ISOLAT:
      *ivalp = celp->isolat;
      break;
   default:
      return 1;
   }

   return 0;
}

/*--------------------------------------------------------------------------*/

int celprt_(cel)

int *cel;

{
   return celprt((struct celprm *)cel);
}

/*--------------------------------------------------------------------------*/

int celset_(cel)

int *cel;

{
   return celset((struct celprm *)cel);
}

/*--------------------------------------------------------------------------*/

int celx2s_(cel, nx, ny, sxy, sll, x, y, phi, theta, lng, lat, stat)

int *cel;
const int *nx, *ny, *sxy, *sll;
const double x[], y[];
double phi[], theta[];
double lng[], lat[];
int stat[];

{
   return celx2s((struct celprm *)cel, *nx, *ny, *sxy, *sll, x, y, phi, theta,
                  lng, lat, stat);
}

/*--------------------------------------------------------------------------*/

int cels2x_(cel, nlng, nlat, sll, sxy, lng, lat, phi, theta, x, y, stat)

int *cel;
const int *nlng, *nlat, *sll, *sxy;
const double lng[], lat[];
double phi[], theta[];
double x[], y[];
int stat[];

{
   return cels2x((struct celprm *)cel, *nlng, *nlat, *sll, *sxy, lng, lat,
                  phi, theta, x, y, stat);
}
