*=======================================================================
*
*   WCSLIB 3.0 - an implementation of the FITS WCS convention.
*   Copyright (C) 1995-2003, Mark Calabretta
*
*   This library is free software; you can redistribute it and/or modify
*   it under the terms of the GNU Library General Public License as
*   published by the Free Software Foundation; either version 2 of the
*   License, or (at your option) any later version.
*
*   This library is distributed in the hope that it will be useful, 
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*   Library General Public License for more details.
*
*   You should have received a copy of the GNU Library General Public
*   License along with this library; if not, write to the Free
*   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*   Correspondence concerning WCSLIB may be directed to:
*      Internet email: mcalabre@atnf.csiro.au
*      Postal address: Dr. Mark Calabretta
*                      Australia Telescope National Facility, CSIRO
*                      PO Box 76
*                      Epping NSW 1710
*                      AUSTRALIA
*
*   Author: Mark Calabretta, Australia Telescope National Facility
*   $Id: wcs.inc,v 3.0 2003/04/01 05:49:32 mcalabre Exp $
*=======================================================================

*     Functions.
      INTEGER   WCSINI, WCSCPY, WCSPUT, WCSGET, WCSFREE, WCSPRT, WCSSET,
     :          WCSP2S, WCSS2P, WCSMIX

*     Length of the WCSPRM data structure (INTEGER array).
      INTEGER   WCSLEN
      PARAMETER (WCSLEN = 238)

*     Codes for WCS data structure elements used by WCSPUT and WCSGET.
      INTEGER   WCS_ALTLIN, WCS_CD, WCS_CDELT, WCS_CROTA, WCS_CRPIX,
     :          WCS_CRVAL, WCS_CTYPE, WCS_FLAG, WCS_LATPOLE,
     :          WCS_LONPOLE, WCS_NAXIS, WCS_NPV, WCS_PC, WCS_PV,
     :          WCS_RESTFRQ, WCS_RESTWAV

      PARAMETER (WCS_FLAG     = 100)
      PARAMETER (WCS_NAXIS    = 101)
      PARAMETER (WCS_CRPIX    = 102)
      PARAMETER (WCS_PC       = 103)
      PARAMETER (WCS_CDELT    = 104)
      PARAMETER (WCS_CTYPE    = 105)
      PARAMETER (WCS_CRVAL    = 106)
      PARAMETER (WCS_LONPOLE  = 107)
      PARAMETER (WCS_LATPOLE  = 108)
      PARAMETER (WCS_RESTFRQ  = 109)
      PARAMETER (WCS_RESTWAV  = 110)
      PARAMETER (WCS_NPV      = 111)
      PARAMETER (WCS_PV       = 112)
      PARAMETER (WCS_ALTLIN   = 113)
      PARAMETER (WCS_CD       = 114)
      PARAMETER (WCS_CROTA    = 115)

*     Codes for WCS data structure elements used by WCSGET (only).
      INTEGER   WCS_CEL, WCS_CUBEFACE, WCS_LAT, WCS_LATTYP, WCS_LIN,
     :          WCS_LNG, WCS_LNGTYP, WCS_SPC, WCS_SPEC

      PARAMETER (WCS_LNGTYP   = 200)
      PARAMETER (WCS_LATTYP   = 201)
      PARAMETER (WCS_LNG      = 202)
      PARAMETER (WCS_LAT      = 203)
      PARAMETER (WCS_SPEC     = 204)
      PARAMETER (WCS_CUBEFACE = 205)
      PARAMETER (WCS_LIN      = 206)
      PARAMETER (WCS_CEL      = 207)
      PARAMETER (WCS_SPC      = 208)
