/*============================================================================
*
*   WCSLIB 3.2 - an implementation of the FITS WCS convention.
*   Copyright (C) 1995-2003, Mark Calabretta
*
*   This library is free software; you can redistribute it and/or modify it
*   under the terms of the GNU Library General Public License as published
*   by the Free Software Foundation; either version 2 of the License, or (at
*   your option) any later version.
*
*   This library is distributed in the hope that it will be useful, but
*   WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library
*   General Public License for more details.
*
*   You should have received a copy of the GNU Library General Public License
*   along with this library; if not, write to the Free Software Foundation,
*   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*   Correspondence concerning WCSLIB may be directed to:
*      Internet email: mcalabre@atnf.csiro.au
*      Postal address: Dr. Mark Calabretta
*                      Australia Telescope National Facility, CSIRO
*                      PO Box 76
*                      Epping NSW 1710
*                      AUSTRALIA
*
*   Author: Mark Calabretta, Australia Telescope National Facility
*   $Id: spc_f.c,v 3.2 2003/09/09 03:56:19 mcalabre Exp $
*===========================================================================*/

#include <string.h>
#include <spc.h>

#define SPC_FLAG    100
#define SPC_TYPE    101
#define SPC_CODE    102
#define SPC_CRVAL   103
#define SPC_RESTFRQ 104
#define SPC_RESTWAV 105
#define SPC_PV      106

#define SPC_W       200
#define SPC_ISGRISM 201

/*--------------------------------------------------------------------------*/

int spcini_(spc)

int *spc;

{
   return spcini((struct spcprm *)spc);
}

/*--------------------------------------------------------------------------*/

int spcput_(spc, what, value, m)

int *spc;
const int *what;
const void *value;
const int *m;

{
   const char *cvalp;
   const int  *ivalp;
   const double *dvalp;
   struct spcprm *spcp;

   /* Cast pointers. */
   spcp  = (struct spcprm *)spc;
   cvalp = (const char *)value;
   ivalp = (const int *)value;
   dvalp = (const double *)value;

   spcp->flag = 0;

   switch (*what) {
   case SPC_FLAG:
      spcp->flag = *ivalp;
      break;
   case SPC_TYPE:
      strncpy(spcp->type, cvalp, 4);
      spcp->type[4] = '\0';
      break;
   case SPC_CODE:
      strncpy(spcp->code, cvalp, 3);
      spcp->code[3] = '\0';
      break;
   case SPC_CRVAL:
      spcp->crval = *dvalp;
      break;
   case SPC_RESTFRQ:
      spcp->restfrq = *dvalp;
      break;
   case SPC_RESTWAV:
      spcp->restwav = *dvalp;
      break;
   case SPC_PV:
      spcp->pv[*m] = *dvalp;
      break;
   default:
      return 1;
   }

   return 0;
}

/*--------------------------------------------------------------------------*/

int spcget_(spc, what, value)

const int *spc;
const int *what;
void *value;

{
   int m;
   char *cvalp;
   int  *ivalp;
   double *dvalp;
   const struct spcprm *spcp;

   /* Cast pointers. */
   spcp  = (const struct spcprm *)spc;
   cvalp = (char *)value;
   ivalp = (int *)value;
   dvalp = (double *)value;

   switch (*what) {
   case SPC_FLAG:
      *ivalp = spcp->flag;
      break;
   case SPC_TYPE:
      strncpy(cvalp, spcp->type, 4);
      break;
   case SPC_CODE:
      strncpy(cvalp, spcp->code, 3);
      break;
   case SPC_CRVAL:
      *dvalp = spcp->crval;
      break;
   case SPC_RESTFRQ:
      *dvalp = spcp->restfrq;
      break;
   case SPC_RESTWAV:
      *dvalp = spcp->restwav;
      break;
   case SPC_PV:
      for (m = 0; m < 7; m++) {
         *(dvalp++) = spcp->pv[m];
      }
      break;
   case SPC_W:
      for (m = 0; m < 6; m++) {
         *(dvalp++) = spcp->w[m];
      }
      break;
   case SPC_ISGRISM:
      *ivalp = spcp->isGrism;
      break;
   default:
      return 1;
   }

   return 0;
}

/*--------------------------------------------------------------------------*/

int spcprt_(spc)

int *spc;

{
   return spcprt((struct spcprm *)spc);
}

/*--------------------------------------------------------------------------*/

int spcset_(spc)

int *spc;

{
   return spcset((struct spcprm *)spc);
}

/*--------------------------------------------------------------------------*/

int spcx2s_(spc, nx, sx, sspec, x, spec, stat)

int *spc;
const int *nx, *sspec, *sx;
const double x[];
double spec[];
int stat[];

{
   return spcx2s((struct spcprm *)spc, *nx, *sx, *sspec, x, spec, stat);
}

/*--------------------------------------------------------------------------*/

int spcs2x_(spc, nspec, sspec, sx, spec, x, stat)

int *spc;
const int *nspec, *sspec, *sx;
const double spec[];
double x[];
int stat[];

{
   return spcs2x((struct spcprm *)spc, *nspec, *sspec, *sx, spec, x, stat);
}
