*=======================================================================
*
*   WCSLIB 3.4 - an implementation of the FITS WCS convention.
*   Copyright (C) 1995-2004, Mark Calabretta
*
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
*
*   This program is distributed in the hope that it will be useful, but
*   WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*   General Public License for more details.
*
*   You should have received a copy of the GNU General Public License
*   along with this library; if not, write to the Free Software
*   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*   Correspondence concerning WCSLIB may be directed to:
*      Internet email: mcalabre@atnf.csiro.au
*      Postal address: Dr. Mark Calabretta
*                      Australia Telescope National Facility, CSIRO
*                      PO Box 76
*                      Epping NSW 1710
*                      AUSTRALIA
*
*=======================================================================
      PROGRAM TPRJ2
*-----------------------------------------------------------------------
*   TPRJ2 tests projection routines by plotting test graticules using
*   PGPLOT.
*
*   $Id: tprj2.f,v 3.4 2004/02/11 00:04:18 mcalabre Exp $
*-----------------------------------------------------------------------
      INTEGER   J
      DOUBLE PRECISION PV(0:29)

      DOUBLE PRECISION PI
      PARAMETER (PI = 3.141592653589793238462643D0)
*-----------------------------------------------------------------------
*     Uncomment the following two lines to raise SIGFPE on floating
*     point exceptions for the Sun FORTRAN compiler.  This signal can
*     be caught within 'dbx' by issuing the command "catch FPE".
*#include <f77_floatingpoint.h>
*      call ieee_handler ('set', 'common', SIGFPE_ABORT)

      WRITE (6, 10)
 10   FORMAT ('Testing WCSLIB spherical projection routines',/,
     :        '--------------------------------------------')

      DO 20 J = 0, 29
         PV(J) = 0D0
 20   CONTINUE

*     PGPLOT initialization.
      CALL PGBEG (0, '/xwindow', 1, 1)

*     Define pen colours.
      CALL PGSCR (0, 0.00, 0.00, 0.00)
      CALL PGSCR (1, 1.00, 1.00, 0.00)
      CALL PGSCR (2, 1.00, 1.00, 1.00)
      CALL PGSCR (3, 0.50, 0.50, 0.80)
      CALL PGSCR (4, 0.80, 0.50, 0.50)
      CALL PGSCR (5, 0.80, 0.80, 0.80)
      CALL PGSCR (6, 0.50, 0.50, 0.80)
      CALL PGSCR (7, 0.80, 0.50, 0.50)
      CALL PGSCR (8, 0.30, 0.50, 0.30)

 30   FORMAT(/,A,' projection')
 40   FORMAT(/,A,' projection',/,'Parameters:',5F12.5,/,5F12.5)

*     AZP: zenithal/azimuthal perspective.
      PV(1) =  2D0
      PV(2) = 30D0
      WRITE (6, 40) 'Zenithal/azimuthal perspective', (PV(J), J=1,2)
      CALL PRJPLT ('AZP', 90, -90, PV)

*     SZP: zenithal/azimuthal perspective.
      PV(1) =   2D0
      PV(2) = 210D0
      PV(3) =  60D0
      WRITE (6, 40) 'Slant zenithal perspective', (PV(J), J=1,3)
      CALL PRJPLT ('SZP', 90, -90, PV)

*     TAN: gnomonic.
      WRITE (6, 30) 'Gnomonic'
      CALL PRJPLT ('TAN', 90,   5, PV)

*     STG: stereographic.
      WRITE (6, 30) 'Stereographic'
      CALL PRJPLT ('STG', 90, -85, PV)

*     SIN: orthographic.
      PV(1) = -0.3D0
      PV(2) =  0.5D0
      WRITE (6, 40) 'Orthographic/synthesis', (PV(J), J=1,2)
      CALL PRJPLT ('SIN', 90, -90, PV)

*     ARC: zenithal/azimuthal equidistant.
      WRITE (6, 30) 'Zenithal/azimuthal equidistant'
      CALL PRJPLT ('ARC', 90, -90, PV)

*     ZPN: zenithal/azimuthal polynomial.
      PV(0) =  0.05000D0
      PV(1) =  0.95000D0
      PV(2) = -0.02500D0
      PV(3) = -0.15833D0
      PV(4) =  0.00208D0
      PV(5) =  0.00792D0
      PV(6) = -0.00007D0
      PV(7) = -0.00019D0
      PV(8) =  0.00000D0
      PV(9) =  0.00000D0
      WRITE (6, 40) 'Zenithal/azimuthal polynomial', (PV(J), J=0,9)
      CALL PRJPLT ('ZPN', 90,  10, PV)

*     ZEA: zenithal/azimuthal equal area.
      WRITE (6, 30) 'Zenithal/azimuthal equal area'
      CALL PRJPLT ('ZEA', 90, -90, PV)

*     AIR: Airy's zenithal projection.
      PV(1) = 45D0
      WRITE (6, 40) 'Airy''s zenithal', PV(1)
      CALL PRJPLT ('AIR', 90, -85, PV)

*     CYP: cylindrical perspective.
      PV(1) = 3.0D0
      PV(2) = 0.8D0
      WRITE (6, 40) 'Cylindrical perspective', (PV(J), J=1,2)
      CALL PRJPLT ('CYP', 90, -90, PV)

*     CEA: cylindrical equal area.
      PV(1) = 0.75D0
      WRITE (6, 40) 'Cylindrical equal area', PV(1)
      CALL PRJPLT ('CEA', 90, -90, PV)

*     CAR: plate carree.
      WRITE (6, 30) 'Plate carree'
      CALL PRJPLT ('CAR', 90, -90, PV)

*     MER: Mercator's.
      WRITE (6, 30) 'Mercator''s'
      CALL PRJPLT ('MER', 85, -85, PV)

*     SFL: Sanson-Flamsteed.
      WRITE (6, 30) 'Sanson-Flamsteed (global sinusoid)'
      CALL PRJPLT ('SFL', 90, -90, PV)

*     PAR: parabolic.
      WRITE (6, 30) 'Parabolic'
      CALL PRJPLT ('PAR', 90, -90, PV)

*     MOL: Mollweide's projection.
      WRITE (6, 30) 'Mollweide''s'
      CALL PRJPLT ('MOL', 90, -90, PV)

*     AIT: Hammer-Aitoff.
      WRITE (6, 30) 'Hammer-Aitoff'
      CALL PRJPLT ('AIT', 90, -90, PV)

*     COP: conic perspective.
      PV(1) =  60D0
      PV(2) =  15D0
      WRITE (6, 40) 'Conic perspective', (PV(J), J=1,2)
      CALL PRJPLT ('COP', 90, -25, PV)

*     COE: conic equal area.
      PV(1) =  60D0
      PV(2) = -15D0
      WRITE (6, 40) 'Conic equal area', (PV(J), J=1,2)
      CALL PRJPLT ('COE', 90, -90, PV)

*     COD: conic equidistant.
      PV(1) = -60D0
      PV(2) =  15D0
      WRITE (6, 40) 'Conic equidistant', (PV(J), J=1,2)
      CALL PRJPLT ('COD', 90, -90, PV)

*     COO: conic orthomorphic.
      PV(1) = -60D0
      PV(2) = -15D0
      WRITE (6, 40) 'Conic orthomorphic', (PV(J), J=1,2)
      CALL PRJPLT ('COO', 85, -90, PV)

*     BON: Bonne's projection.
      PV(1) = 30D0
      WRITE (6, 40) 'Bonne''s', PV(1)
      CALL PRJPLT ('BON', 90, -90, PV)

*     PCO: polyconic.
      WRITE (6, 30) 'Polyconic'
      CALL PRJPLT ('PCO', 90, -90, PV)

*     TSC: tangential spherical cube.
      WRITE (6, 30) 'Tangential spherical cube'
      CALL PRJPLT ('TSC', 90, -90, PV)

*     CSC: COBE quadrilateralized spherical cube.
      WRITE (6, 30) 'COBE quadrilateralized spherical cube'
      CALL PRJPLT ('CSC', 90, -90, PV)

*     QSC: quadrilateralized spherical cube.
      WRITE (6, 30) 'Quadrilateralized spherical cube'
      CALL PRJPLT ('QSC', 90, -90, PV)

      CALL PGASK (0)
      CALL PGEND

      END


      SUBROUTINE PRJPLT (PCODE, NORTH, SOUTH, PV)
*-----------------------------------------------------------------------
*   PRJPLT draws a 15 degree coordinate graticule.
*
*   Given:
*      PCODE    C*3      Projection code.
*      NORTH    I        Northern cutoff latitude, degrees.
*      SOUTH    I        Southern cutoff latitude, degrees.
*      PV       D(0:29)  Projection parameters.
*-----------------------------------------------------------------------
      LOGICAL   CUBIC
      INTEGER   CI, ILAT, ILNG, J, K, LEN, NORTH, SOUTH, STAT(361),
     :          STATUS
      REAL      XR(512), YR(512)
      DOUBLE PRECISION LAT(361), LNG(361), PV(0:29), X(361), X0, Y(361),
     :          Y0
      CHARACTER PCODE*3

      INCLUDE 'prj.inc'
      INTEGER   PRJ(PRJLEN)
*-----------------------------------------------------------------------
      STATUS = PRJINI(PRJ)

      STATUS = PRJPUT (PRJ, PRJ_CODE, PCODE, 0)

      DO 10 J = 0, 29
         STATUS = PRJPUT (PRJ, PRJ_PV, PV(J), J)
 10   CONTINUE

      WRITE (6, 20) PCODE, NORTH, SOUTH
 20   FORMAT ('Plotting ',A3,'; Latitudes',I3,' to',I4,'.')

      CALL PGASK (0)

      STATUS = PRJSET(PRJ)
      STATUS = PRJGET (PRJ, PRJ_CATEGORY, J)
      CUBIC  = J.EQ.7
      IF (CUBIC) THEN
         CALL PGENV (-335.0, 65.0, -200.0, 200.0, 1, -2)
         CALL PGSCI (2)
         CALL PGTEXT (-340.0, -220.0, PCODE//' - 15 degree graticule')

         CALL PGSCI (8)

         STATUS = PRJGET (PRJ, PRJ_X0, X0)
         STATUS = PRJGET (PRJ, PRJ_Y0, Y0)
         XR(1) =      45.0 + X0
         YR(1) =      45.0 - Y0
         XR(2) =      45.0 + X0
         YR(2) =  3.0*45.0 - Y0
         XR(3) =     -45.0 + X0
         YR(3) =  3.0*45.0 - Y0
         XR(4) =     -45.0 + X0
         YR(4) = -3.0*45.0 - Y0
         XR(5) =      45.0 + X0
         YR(5) = -3.0*45.0 - Y0
         XR(6) =      45.0 + X0
         YR(6) =      45.0 - Y0
         XR(7) = -7.0*45.0 + X0
         YR(7) =      45.0 - Y0
         XR(8) = -7.0*45.0 + X0
         YR(8) =     -45.0 - Y0
         XR(9) =      45.0 + X0
         YR(9) =     -45.0 - Y0
         CALL PGLINE (9, XR, YR)
      ELSE
         CALL PGENV (-200.0, 200.0, -200.0, 200.0, 1, -2)
         CALL PGSCI (2)
         CALL PGTEXT (-240.0, -220.0, PCODE//' - 15 degree graticule')
      END IF


      CI = 1
      DO 50 ILNG = -180, 180, 15
         CI = CI + 1
         IF (CI.GT.7) CI = 2

         LNG(1) = DBLE(ILNG)

         IF (ILNG.EQ.0) THEN
            CALL PGSCI (1)
         ELSE
            CALL PGSCI (CI)
         END IF

         LEN  = NORTH - SOUTH + 1
         ILAT = NORTH
         DO 30 J = 1, LEN
            LAT(J) = DBLE(ILAT)
            ILAT = ILAT - 1
 30      CONTINUE

         STATUS = PRJS2X (PRJ, 1, LEN, 1, 1, LNG, LAT, X, Y, STAT)

         K = 0
         DO 40 J = 1, LEN
            IF (STAT(J).NE.0) THEN
               IF (K.GT.1) CALL PGLINE (K, XR, YR)
               K = 0
               GO TO 40
            END IF

            IF (CUBIC .AND. J.GT.0) THEN
               IF (ABS(X(J) - X(J-1)).GT.2D0 .OR.
     :             ABS(Y(J) - Y(J-1)).GT.5D0) THEN
                  IF (K.GT.1) CALL PGLINE (K, XR, YR)
                  K = 0
               END IF
            END IF

            K = K + 1
            XR(K) = -X(J)
            YR(K) =  Y(J)
 40      CONTINUE

         CALL PGLINE (K, XR, YR)
 50   CONTINUE

      CI = 1
      DO 80 ILAT = -90, 90, 15
         CI = CI + 1
         IF (CI.GT.7) CI = 2

         IF (ILAT.GT.NORTH) GO TO 80
         IF (ILAT.LT.SOUTH) GO TO 80

         LAT(1) = DBLE(ILAT)

         IF (ILAT.EQ.0) THEN
            CALL PGSCI (1)
         ELSE
            CALL PGSCI (CI)
         END IF

         ILNG = -180
         DO 60 J = 1, 361
            LNG(J) = DBLE(ILNG)
            ILNG = ILNG + 1
 60      CONTINUE

         STATUS = PRJS2X (PRJ, 361, 1, 1, 1, LNG, LAT, X, Y, STAT)

         K = 0
         DO 70 J = 1, 361
            IF (STAT(J).NE.0) THEN
               IF (K.GT.1) CALL PGLINE (K, XR, YR)
               K = 0
               GO TO 70
            END IF

            IF (CUBIC .AND. J.GT.0) THEN
               IF (ABS(X(J) - X(J-1)).GT.2D0 .OR.
     :             ABS(Y(J) - Y(J-1)).GT.5D0) THEN
                  IF (K.GT.1) CALL PGLINE (K, XR, YR)
                  K = 0
               END IF
            END IF

            K = K + 1
            XR(K) = -X(J)
            YR(K) =  Y(J)
 70      CONTINUE

         CALL PGLINE (K, XR, YR)
 80   CONTINUE

      CALL PGSCI(1)
      XR(1) = 0.0
      YR(1) = 0.0
      CALL PGPT (1, XR, YR, 21)

      CALL PGASK (1)
      CALL PGPAGE()


      RETURN
      END
