*=======================================================================
*
*   WCSLIB 3.4 - an implementation of the FITS WCS convention.
*   Copyright (C) 1995-2004, Mark Calabretta
*
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
*
*   This program is distributed in the hope that it will be useful, but
*   WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*   General Public License for more details.
*
*   You should have received a copy of the GNU General Public License
*   along with this library; if not, write to the Free Software
*   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*   Correspondence concerning WCSLIB may be directed to:
*      Internet email: mcalabre@atnf.csiro.au
*      Postal address: Dr. Mark Calabretta
*                      Australia Telescope National Facility, CSIRO
*                      PO Box 76
*                      Epping NSW 1710
*                      AUSTRALIA
*
*=======================================================================
      PROGRAM TLIN
*-----------------------------------------------------------------------
*
*   TLIN tests the linear transformation routines supplied with WCSLIB.
*
*   $Id: tlin.f,v 3.4 2004/02/11 00:04:18 mcalabre Exp $
*-----------------------------------------------------------------------
      INTEGER   NAXIS, NELEM
      PARAMETER (NAXIS = 5)
      PARAMETER (NELEM = 9)

      INTEGER   I, J, STATUS
      DOUBLE PRECISION CDELT(NAXIS), CRPIX(NAXIS), IMG(NELEM,2),
     :          PC(NAXIS,NAXIS), PIX(NELEM,2)

      INCLUDE 'lin.inc'
      INTEGER LIN(LINLEN)

      DATA (CRPIX(I), I=1,NAXIS)
     :           /256D0, 256D0,  64D0, 128D0,   1D0/
      DATA ((PC(I,J),J=1,NAXIS),I=1,NAXIS)
     :           /  1.0D0,   0.5D0,   0D0,   0D0,   0D0,
     :              0.5D0,   1.0D0,   0D0,   0D0,   0D0,
     :              0.0D0,   0.0D0,   1D0,   0D0,   0D0,
     :              0.0D0,   0.0D0,   0D0,   1D0,   0D0,
     :              0.0D0,   0.0D0,   0D0,   0D0,   1D0/
      DATA (CDELT(I), I=1,NAXIS)
     :           /  1.2D0,   2.3D0,   3.4D0,   4.5D0,   5.6D0/
      DATA ((PIX(I,J), I=1,NAXIS), J=1,2)
     :           /303.0D0, 265.0D0, 112.4D0, 144.5D0,  28.2D0,
     :             19.0D0,  57.0D0,   2.0D0,  15.0D0,  42.0D0/
*-----------------------------------------------------------------------
*     Uncomment the following two lines to raise SIGFPE on floating
*     point exceptions for the Sun FORTRAN compiler.  This signal can
*     be caught within 'dbx' by issuing the command "catch FPE".
*#include <f77_floatingpoint.h>
*     call ieee_handler ('set', 'common', SIGFPE_ABORT)

      WRITE (6, 10)
 10   FORMAT (/,'Testing WCSLIB linear transformation routines',/,
     :          '---------------------------------------------')

      STATUS = LINPUT (LIN, LIN_FLAG, -1, 0, 0)
      STATUS = LININI (NAXIS, LIN)

      DO 30 I = 1, NAXIS
         STATUS = LINPUT (LIN, LIN_CRPIX, CRPIX(I), I, 0)

         DO 20 J = 1, NAXIS
            STATUS = LINPUT (LIN, LIN_PC, PC(I,J), I, J)
 20      CONTINUE

         STATUS = LINPUT (LIN, LIN_CDELT, CDELT(I), I, 0)
 30   CONTINUE

      WRITE (6, *)
      WRITE (6, 40) 1, (PIX(J,1), J=1,NAXIS)
      WRITE (6, 40) 2, (PIX(J,2), J=1,NAXIS)
 40   FORMAT ('PIX',I2,':',10F14.8)

      STATUS = LINP2X (LIN, 2, NELEM, PIX, IMG)
      IF (STATUS.NE.0) THEN
         WRITE (6, 50) STATUS
 50      FORMAT ('LINP2X error',I3)
         GO TO 999
      END IF

      WRITE (6, *)
      WRITE (6, 60) 1, (IMG(J,1), J=1,NAXIS)
      WRITE (6, 60) 2, (IMG(J,2), J=1,NAXIS)
 60   FORMAT ('IMG',I2,':',10F14.8)

      STATUS = LINX2P (LIN, 2, NELEM, IMG, PIX)
      IF (STATUS.NE.0) THEN
         WRITE (6, 70) STATUS
 70      FORMAT ('LINX2P error',I3)
         GO TO 999
      END IF

      WRITE (6, *)
      WRITE (6, 40) 1, (PIX(J,1), J=1,NAXIS)
      WRITE (6, 40) 2, (PIX(J,2), J=1,NAXIS)

      STATUS = LINP2X (LIN, 2, NELEM, PIX, IMG)
      IF (STATUS.NE.0) THEN
         WRITE (6, 50) STATUS
         GO TO 999
      END IF

      WRITE (6, *)
      WRITE (6, 60) 1, (IMG(J,1), J=1,NAXIS)
      WRITE (6, 60) 2, (IMG(J,2), J=1,NAXIS)

 999  END
