*=======================================================================
*
*   WCSLIB 3.5 - an implementation of the FITS WCS convention.
*   Copyright (C) 1995-2004, Mark Calabretta
*
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
*
*   This program is distributed in the hope that it will be useful, but
*   WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*   General Public License for more details.
*
*   You should have received a copy of the GNU General Public License
*   along with this library; if not, write to the Free Software
*   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*   Correspondence concerning WCSLIB may be directed to:
*      Internet email: mcalabre@atnf.csiro.au
*      Postal address: Dr. Mark Calabretta
*                      Australia Telescope National Facility, CSIRO
*                      PO Box 76
*                      Epping NSW 1710
*                      AUSTRALIA
*
*   Author: Mark Calabretta, Australia Telescope National Facility
*   http://www.atnf.csiro.au/~mcalabre/index.html
*   $Id: tspc.f,v 3.5 2004/06/28 04:51:50 mcalabre Exp $
*=======================================================================

      PROGRAM TSPC
*-----------------------------------------------------------------------
*
*   TSPC tests the spectral transformation driver routines for closure.
*
*-----------------------------------------------------------------------
*     Maximum length of spectral axis - see CLOSURE.
      INTEGER   NSPEC
      PARAMETER (NSPEC = 10001)

      INTEGER   NAXISJ
      DOUBLE PRECISION C, CDELTX, CRPIXJ, CRVALX, MARS(0:6), RESTFRQ,
     :          RESTWAV, X1, X2

      COMMON /SPECTRO/ MARS

      DATA C /2.99792458D8/

*     KPNO MARS spectrograph grism parameters.
      DATA MARS /4.5D5, 1D0, 27D0, 1.765D0, -1.077D6, 3D0, 5D0/
*-----------------------------------------------------------------------
*     Uncomment the following two lines to raise SIGFPE on floating
*     point exceptions for the Sun FORTRAN compiler.  This signal can
*     be caught within 'dbx' by issuing the command "catch FPE".
*#include <f77_floatingpoint.h>
*      call ieee_handler ('set', 'common', SIGFPE_ABORT)

      WRITE (6, 10)
 10   FORMAT (/,'Testing closure of WCSLIB spectral transformation ',
     :        'routines',/'----------------------------------------',
     :        '------------------')



*     PGPLOT initialization.
      CALL PGBEG (0, '/xwindow', 1, 1)

      NAXISJ = NSPEC
      CRPIXJ = NAXISJ/2 + 1

      RESTFRQ = 1420.40595D6
      RESTWAV = C/RESTFRQ
      X1 = 1D9
      X2 = 2D9
      CDELTX = (X2 - X1)/(NAXISJ - 1)
      CRVALX = X1 + (CRPIXJ - 1.0)*CDELTX
      WRITE (6, 20) X1*1D-9, X2*1D-9, CDELTX*1D-3
 20   FORMAT (/,'Linear frequency axis, span:',F4.1,' to',F4.1,
     :        ' (GHz), step:',F8.3,' (kHz)',/,'---------------------',
     :        '-----------------------------------------------------')
      CALL CLOSURE('WAVE-F2W', RESTFRQ, RESTWAV, NAXISJ, CRPIXJ, CDELTX,
     :             CRVALX)
      CALL CLOSURE('VOPT-F2W', RESTFRQ, RESTWAV, NAXISJ, CRPIXJ, CDELTX,
     :             CRVALX)
      CALL CLOSURE('ZOPT-F2W', RESTFRQ, RESTWAV, NAXISJ, CRPIXJ, CDELTX,
     :             CRVALX)
      CALL CLOSURE('AWAV-F2A', RESTFRQ, RESTWAV, NAXISJ, CRPIXJ, CDELTX,
     :             CRVALX)
      CALL CLOSURE('VELO-F2V', RESTFRQ, RESTWAV, NAXISJ, CRPIXJ, CDELTX,
     :             CRVALX)
      CALL CLOSURE('BETA-F2V', RESTFRQ, RESTWAV, NAXISJ, CRPIXJ, CDELTX,
     :             CRVALX)


      RESTWAV = 700D-9
      RESTFRQ = C/RESTWAV
      X1 = 300D-9
      X2 = 900D-9
      CDELTX = (X2 - X1)/(NAXISJ - 1)
      CRVALX = X1 + (CRPIXJ - 1D0)*CDELTX
      WRITE (6, 30) INT(X1*1D9), INT(X2*1D9), CDELTX*1D9
 30   FORMAT (/,'Linear vacuum wavelength axis, span:',I4,' to',I4,
     :        ' (nm), step:',F9.6,' (nm)',/,'----------------------',
     :        '----------------------------------------------------')
      CALL CLOSURE('FREQ-W2F', RESTFRQ, RESTWAV, NAXISJ, CRPIXJ, CDELTX,
     :             CRVALX)
      CALL CLOSURE('AFRQ-W2F', RESTFRQ, RESTWAV, NAXISJ, CRPIXJ, CDELTX,
     :             CRVALX)
      CALL CLOSURE('ENER-W2F', RESTFRQ, RESTWAV, NAXISJ, CRPIXJ, CDELTX,
     :             CRVALX)
      CALL CLOSURE('WAVN-W2F', RESTFRQ, RESTWAV, NAXISJ, CRPIXJ, CDELTX,
     :             CRVALX)
      CALL CLOSURE('VRAD-W2F', RESTFRQ, RESTWAV, NAXISJ, CRPIXJ, CDELTX,
     :             CRVALX)
      CALL CLOSURE('AWAV-W2A', RESTFRQ, RESTWAV, NAXISJ, CRPIXJ, CDELTX,
     :             CRVALX)
      CALL CLOSURE('VELO-W2V', RESTFRQ, RESTWAV, NAXISJ, CRPIXJ, CDELTX,
     :             CRVALX)
      CALL CLOSURE('BETA-W2V', RESTFRQ, RESTWAV, NAXISJ, CRPIXJ, CDELTX,
     :             CRVALX)


      WRITE (6, 40) INT(X1*1D9), INT(X2*1D9), CDELTX*1D9
 40   FORMAT (/,'Linear air wavelength axis, span:',I4,' to',I4,
     :        ' (nm), step:',F9.6,' (nm)',/,'----------------------',
     :        '----------------------------------------------------')
      CALL CLOSURE('FREQ-A2F', RESTFRQ, RESTWAV, NAXISJ, CRPIXJ, CDELTX,
     :             CRVALX)
      CALL CLOSURE('AFRQ-A2F', RESTFRQ, RESTWAV, NAXISJ, CRPIXJ, CDELTX,
     :             CRVALX)
      CALL CLOSURE('ENER-A2F', RESTFRQ, RESTWAV, NAXISJ, CRPIXJ, CDELTX,
     :             CRVALX)
      CALL CLOSURE('WAVN-A2F', RESTFRQ, RESTWAV, NAXISJ, CRPIXJ, CDELTX,
     :             CRVALX)
      CALL CLOSURE('VRAD-A2F', RESTFRQ, RESTWAV, NAXISJ, CRPIXJ, CDELTX,
     :             CRVALX)
      CALL CLOSURE('WAVE-A2W', RESTFRQ, RESTWAV, NAXISJ, CRPIXJ, CDELTX,
     :             CRVALX)
      CALL CLOSURE('VOPT-A2W', RESTFRQ, RESTWAV, NAXISJ, CRPIXJ, CDELTX,
     :             CRVALX)
      CALL CLOSURE('ZOPT-A2W', RESTFRQ, RESTWAV, NAXISJ, CRPIXJ, CDELTX,
     :             CRVALX)
      CALL CLOSURE('VELO-A2V', RESTFRQ, RESTWAV, NAXISJ, CRPIXJ, CDELTX,
     :             CRVALX)
      CALL CLOSURE('BETA-A2V', RESTFRQ, RESTWAV, NAXISJ, CRPIXJ, CDELTX,
     :             CRVALX)


      RESTFRQ = 1420.40595D6
      RESTWAV = C/RESTFRQ
      X1 = -0.96D0*C
      X2 =  0.96D0*C
      CDELTX = (X2 - X1)/(NAXISJ - 1)
      CRVALX = X1 + (CRPIXJ - 1D0)*CDELTX
      WRITE (6, 50) INT(X1), INT(X2), INT(CDELTX)
 50   FORMAT (/,'Linear velocity axis, span:',I11,' to',I10,
     :        ' m/s, step:',I6,' (m/s)',/,'-----------------------',
     :        '---------------------------------------------------')
      CALL CLOSURE('FREQ-V2F', RESTFRQ, RESTWAV, NAXISJ, CRPIXJ, CDELTX,
     :             CRVALX)
      CALL CLOSURE('AFRQ-V2F', RESTFRQ, RESTWAV, NAXISJ, CRPIXJ, CDELTX,
     :             CRVALX)
      CALL CLOSURE('ENER-V2F', RESTFRQ, RESTWAV, NAXISJ, CRPIXJ, CDELTX,
     :             CRVALX)
      CALL CLOSURE('WAVN-V2F', RESTFRQ, RESTWAV, NAXISJ, CRPIXJ, CDELTX,
     :             CRVALX)
      CALL CLOSURE('VRAD-V2F', RESTFRQ, RESTWAV, NAXISJ, CRPIXJ, CDELTX,
     :             CRVALX)
      CALL CLOSURE('WAVE-V2W', RESTFRQ, RESTWAV, NAXISJ, CRPIXJ, CDELTX,
     :             CRVALX)
      CALL CLOSURE('VOPT-V2W', RESTFRQ, RESTWAV, NAXISJ, CRPIXJ, CDELTX,
     :             CRVALX)
      CALL CLOSURE('ZOPT-V2W', RESTFRQ, RESTWAV, NAXISJ, CRPIXJ, CDELTX,
     :             CRVALX)
      CALL CLOSURE('AWAV-V2A', RESTFRQ, RESTWAV, NAXISJ, CRPIXJ, CDELTX,
     :             CRVALX)


      RESTWAV = 650D-9
      RESTFRQ = C/RESTWAV
      X1 =  300D-9
      X2 = 1000D-9
      CDELTX = (X2 - X1)/(NAXISJ - 1)
      CRVALX = X1 + (CRPIXJ - 1D0)*CDELTX
      WRITE (6, 60) INT(X1*1D9), INT(X2*1D9), CDELTX*1D9
 60   FORMAT (/,'Vacuum wavelength grism axis, span:',I4,' to',I5,
     :        ' (nm), step:',F9.6,' (nm)',/,'----------------------',
     :        '----------------------------------------------------')
      CALL CLOSURE('FREQ-GRI', RESTFRQ, RESTWAV, NAXISJ, CRPIXJ, CDELTX,
     :             CRVALX)
      CALL CLOSURE('AFRQ-GRI', RESTFRQ, RESTWAV, NAXISJ, CRPIXJ, CDELTX,
     :             CRVALX)
      CALL CLOSURE('ENER-GRI', RESTFRQ, RESTWAV, NAXISJ, CRPIXJ, CDELTX,
     :             CRVALX)
      CALL CLOSURE('WAVN-GRI', RESTFRQ, RESTWAV, NAXISJ, CRPIXJ, CDELTX,
     :             CRVALX)
      CALL CLOSURE('VRAD-GRI', RESTFRQ, RESTWAV, NAXISJ, CRPIXJ, CDELTX,
     :             CRVALX)
      CALL CLOSURE('WAVE-GRI', RESTFRQ, RESTWAV, NAXISJ, CRPIXJ, CDELTX,
     :             CRVALX)
      CALL CLOSURE('VOPT-GRI', RESTFRQ, RESTWAV, NAXISJ, CRPIXJ, CDELTX,
     :             CRVALX)
      CALL CLOSURE('ZOPT-GRI', RESTFRQ, RESTWAV, NAXISJ, CRPIXJ, CDELTX,
     :             CRVALX)
      CALL CLOSURE('AWAV-GRI', RESTFRQ, RESTWAV, NAXISJ, CRPIXJ, CDELTX,
     :             CRVALX)
      CALL CLOSURE('VELO-GRI', RESTFRQ, RESTWAV, NAXISJ, CRPIXJ, CDELTX,
     :             CRVALX)
      CALL CLOSURE('BETA-GRI', RESTFRQ, RESTWAV, NAXISJ, CRPIXJ, CDELTX,
     :             CRVALX)


*     Reproduce Fig. 5 of Paper III.
      NAXISJ = 1700
      CRPIXJ = 719.8D0
      CRVALX = 7245.2D-10
      CDELTX = 2.956D-10
      RESTWAV = 8500D-10
      RESTFRQ = C/RESTWAV
      X1 = CRVALX + (1 - CRPIXJ)*CDELTX
      X2 = CRVALX + (NAXISJ - CRPIXJ)*CDELTX
      MARS(5) = 0D0
      MARS(6) = 0D0
      WRITE (6, 70) INT(X1*1D9), INT(X2*1D9), CDELTX*1D9
 70   FORMAT (/,'Air wavelength grism axis, span:',I4,' to',I5,
     :        ' (nm), step:',F9.6,' (nm)',/,'----------------------',
     :        '----------------------------------------------------')
      CALL CLOSURE('AWAV-GRA', RESTFRQ, RESTWAV, NAXISJ, CRPIXJ, CDELTX,
     :             CRVALX)
      CALL CLOSURE('VELO-GRA', RESTFRQ, RESTWAV, NAXISJ, CRPIXJ, CDELTX,
     :             CRVALX)

      CALL PGASK(0)
      CALL PGEND()

      END

*=======================================================================

      SUBROUTINE CLOSURE (CTYPE, RESTFRQ, RESTWAV, NAXISJ, CRPIXJ,
     :   CDELTX, CRVALX)

      INTEGER   NSPEC
      PARAMETER (NSPEC = 10001)

      INTEGER   J, NAXISJ, STAT1(NSPEC), STAT2(NSPEC), STATUS
      REAL      TMP, X(NSPEC), XMIN, XMAX, Y(NSPEC), YMAX, YMIN
      DOUBLE PRECISION CDELTS, CDELTX, CLOS(NSPEC), CRPIXJ, CRVALS,
     :          CRVALX, DQDX, DSDQ, MARS(0:6), RESID, RESIDMAX, RESTFRQ,
     :          RESTWAV, SPEC1(NSPEC), SPEC2(NSPEC), TOL
      CHARACTER CTYPE*8, CTYPES*4, CTYPEX*4, QTYPE, STYPE*32, TITLE*80,
     :          UNITS*8, XTYPE, YLAB*80

      INCLUDE 'spx.inc'
      INCLUDE 'spc.inc'
      INTEGER   SPC(SPCLEN)

      COMMON /SPECTRO/ MARS

      DATA TOL /1D-11/
*-----------------------------------------------------------------------
      STATUS = SPCINI(SPC)

*     Construct a linear axis of the required X-type.
      XTYPE = CTYPE(6:6)
      IF (XTYPE.EQ.'F') THEN
         CTYPEX = 'FREQ'
      ELSE IF (XTYPE.EQ.'W') THEN
         CTYPEX = 'WAVE'
      ELSE IF (XTYPE.EQ.'A') THEN
         CTYPEX = 'AWAV'
      ELSE IF (XTYPE.EQ.'V') THEN
         CTYPEX = 'VELO'
      ELSE IF (XTYPE.EQ.'G') THEN
*        KPNO MARS spectrograph grism parameters.
         STATUS = SPCPUT (SPC, SPC_PV, MARS(0), 0)
         STATUS = SPCPUT (SPC, SPC_PV, MARS(1), 1)
         STATUS = SPCPUT (SPC, SPC_PV, MARS(2), 2)
         STATUS = SPCPUT (SPC, SPC_PV, MARS(3), 3)
         STATUS = SPCPUT (SPC, SPC_PV, MARS(4), 4)
         STATUS = SPCPUT (SPC, SPC_PV, MARS(5), 5)
         STATUS = SPCPUT (SPC, SPC_PV, MARS(6), 6)

*        CDELTX and CRVALX were given as wavelengths...
         IF (CTYPE(8:8).EQ.'I') THEN
*           ...in vacuum.
            XTYPE  = 'W'
            CTYPEX = 'WAVE'
         ELSE
*           ...in air.
            XTYPE  = 'A'
            CTYPEX = 'AWAV'
         END IF
      ELSE
         RETURN
      END IF

      STATUS = SPECX(CTYPEX, CRVALX, RESTFRQ, RESTWAV, SPX)

*     What is the required spectral type?
      CTYPES = CTYPE(1:4)
      DSDQ   = 1D0
      IF (CTYPES.EQ.'FREQ') THEN
         STYPE  = 'Frequency'
         UNITS  = '(Hz)'
         CRVALS = SPX_FREQ
         QTYPE  = 'F'
      ELSE IF (CTYPES.EQ.'AFRQ') THEN
         STYPE  = 'Angular frequency'
         UNITS  = '(deg/s)'
         CRVALS = SPX_AFRQ
         DSDQ   = SPX_DAFRQFREQ
         QTYPE  = 'F'
      ELSE IF (CTYPES.EQ.'ENER') THEN
         STYPE  = 'Photon energy'
         UNITS  = '(J)'
         CRVALS = SPX_ENER
         DSDQ   = SPX_DENERFREQ
         QTYPE  = 'F'
      ELSE IF (CTYPES.EQ.'WAVN') THEN
         STYPE  = 'Wavenumber'
         UNITS  = '(1/m)'
         CRVALS = SPX_WAVN
         DSDQ   = SPX_DWAVNFREQ
         QTYPE  = 'F'
      ELSE IF (CTYPES.EQ.'VRAD') THEN
         STYPE  = 'Radio velocity'
         UNITS  = '(m/s)'
         CRVALS = SPX_VRAD
         DSDQ   = SPX_DVRADFREQ
         QTYPE  = 'F'
      ELSE IF (CTYPES.EQ.'WAVE') THEN
         STYPE  = 'Vacuum wavelength'
         UNITS  = '(m)'
         CRVALS = SPX_WAVE
         QTYPE  = 'W'
      ELSE IF (CTYPES.EQ.'VOPT') THEN
         STYPE  = 'Optical velocity'
         UNITS  = '(m/s)'
         CRVALS = SPX_VOPT
         DSDQ   = SPX_DVOPTWAVE
         QTYPE  = 'W'
      ELSE IF (CTYPES.EQ.'ZOPT') THEN
         STYPE  = 'Redshift'
         UNITS  = ' '
         CRVALS = SPX_ZOPT
         DSDQ   = SPX_DZOPTWAVE
         QTYPE  = 'W'
      ELSE IF (CTYPES.EQ.'AWAV') THEN
         STYPE  = 'Air wavelength'
         UNITS  = '(m)'
         CRVALS = SPX_AWAV
         QTYPE  = 'A'
      ELSE IF (CTYPES.EQ.'VELO') THEN
         STYPE  = 'Relativistic velocity'
         UNITS  = '(m/s)'
         CRVALS = SPX_VELO
         QTYPE  = 'V'
      ELSE IF (CTYPES.EQ.'BETA') THEN
         STYPE  = 'Velocity ratio (v/c)'
         UNITS  = ' '
         CRVALS = SPX_BETA
         DSDQ   = SPX_DBETAVELO
         QTYPE  = 'V'
      ELSE
         RETURN
      END IF

*     Find dQ/dX.
      DQDX = 1D0
      IF (XTYPE.EQ.'F') THEN
         IF (QTYPE.EQ.'W') THEN
            DQDX = SPX_DWAVEFREQ
         ELSE IF (QTYPE.EQ.'A') THEN
            DQDX = SPX_DAWAVFREQ
         ELSE IF (QTYPE.EQ.'V') THEN
            DQDX = SPX_DVELOFREQ
         END IF
      ELSE IF (XTYPE.EQ.'W') THEN
         IF (QTYPE.EQ.'F') THEN
            DQDX = SPX_DFREQWAVE
         ELSE IF (QTYPE.EQ.'A') THEN
            DQDX = SPX_DAWAVWAVE
         ELSE IF (QTYPE.EQ.'V') THEN
            DQDX = SPX_DVELOWAVE
         END IF
      ELSE IF (XTYPE.EQ.'A') THEN
         IF (QTYPE.EQ.'F') THEN
            DQDX = SPX_DFREQAWAV
         ELSE IF (QTYPE.EQ.'W') THEN
            DQDX = SPX_DWAVEAWAV
         ELSE IF (QTYPE.EQ.'V') THEN
            DQDX = SPX_DVELOAWAV
         END IF
      ELSE IF (XTYPE.EQ.'V') THEN
         IF (QTYPE.EQ.'F') THEN
            DQDX = SPX_DFREQVELO
         ELSE IF (QTYPE.EQ.'W') THEN
            DQDX = SPX_DWAVEVELO
         ELSE IF (QTYPE.EQ.'A') THEN
            DQDX = SPX_DAWAVVELO
         END IF
      END IF

      CDELTS = DSDQ * DQDX * CDELTX

*     Construct the axis.
      DO 10 J = 1, NAXISJ
         SPEC1(J) = (J - CRPIXJ)*CDELTS
 10   CONTINUE

      WRITE (6, 20) CTYPES, CRVALS+SPEC1(1), CRVALS+SPEC1(NAXISJ),
     :              CDELTS
 20   FORMAT (A,' (CRVALk+w) range: ',1PE13.6,' to ',1PE13.6,', step: ',
     :        1PE13.6)


*     Initialize.
      STATUS = SPCPUT (SPC, SPC_FLAG, 0, 0)
      STATUS = SPCPUT (SPC, SPC_CRVAL, CRVALS, 0)
      STATUS = SPCPUT (SPC, SPC_RESTFRQ, RESTFRQ, 0)
      STATUS = SPCPUT (SPC, SPC_RESTWAV, RESTWAV, 0)
      STATUS = SPCPUT (SPC, SPC_TYPE, CTYPES, 0)
      STATUS = SPCPUT (SPC, SPC_CODE, CTYPE(6:8), 0)

*     Convert the first to the second.
      STATUS = SPCX2S(SPC, NAXISJ, 1, 1, SPEC1, SPEC2, STAT1)
      IF (STATUS.NE.0) THEN
         WRITE (6, 30) STATUS
 30      FORMAT ('SPCX2S: Error',I2,'.')
         RETURN
      END IF

*     Convert the second back to the first.
      STATUS = SPCS2X(SPC, NAXISJ, 1, 1, SPEC2, CLOS, STAT2)
      IF (STATUS.NE.0) THEN
         WRITE (6, 40) STATUS
 40      FORMAT ('SPCS2X: Error',I2,'.')
         RETURN
      END IF

      RESIDMAX = 0D0

*     Test closure.
      DO 80 J = 1, NAXISJ
         IF (STAT1(J).NE.0) THEN
            WRITE (6, 50) CTYPE, SPEC1(J), CTYPES, STAT1(J)
 50         FORMAT (A,': w =',1PE20.12,' -> ',A,' = ???, stat = ',I2)
            GO TO 80
         END IF

         IF (STAT2(J).NE.0) THEN
            WRITE (6, 60) CTYPE, SPEC1(J), CTYPES, SPEC2(J), STAT2(J)
 60         FORMAT (A,': w =',1PE20.12,' -> ',A,' =',1PE20.12,
     :              ' -> w = ???, stat = ',I2)
            GO TO 80
         END IF

         RESID = ABS((CLOS(J) - SPEC1(J))/CDELTS)
         IF (RESID.GT.RESIDMAX) RESIDMAX = RESID

         IF (RESID.GT.TOL) THEN
            WRITE (6, 70) CTYPE, SPEC1(J), CTYPES, SPEC2(J), CLOS(J),
     :                    RESID
 70         FORMAT (A,': w =',1PE20.12,' -> ',A,' =',1PE20.12,' ->',/,
     :             '          w =',1PE20.12,',  resid =',1PE20.12)
         END IF
 80   CONTINUE

      WRITE (6, 90) CTYPE, RESIDMAX
 90   FORMAT (A,': Maximum closure residual =',1PE19.12,' pixel')


*     Draw graph.
      CALL PGBBUF()
      CALL PGERAS()

      XMIN = REAL(CRVALS + SPEC1(1))
      XMAX = REAL(CRVALS + SPEC1(NAXISJ))
      YMIN = REAL(SPEC2(1)) - XMIN
      YMAX = YMIN
      DO 100 J = 1, NAXISJ
         X(J) = REAL(J)
         Y(J) = REAL(SPEC2(J) - (CRVALS + SPEC1(J)))
         IF (Y(J).GT.YMAX) YMAX = Y(J)
         IF (Y(J).LT.YMIN) YMIN = Y(J)
 100  CONTINUE

      J = INT(CRPIXJ+1)
      IF (Y(J).LT.0D0) then
         TMP  = YMIN
         YMIN = YMAX
         YMAX = TMP
      END IF

      CALL PGASK(0)
      CALL PGENV(1.0, REAL(NAXISJ), YMIN, YMAX, 0, -1)

      CALL PGSCI(1)
      CALL PGBOX('ABNTS', 0.0, 0, 'BNTS', 0.0, 0)

      DO 110 J = 32, 1, -1
         IF (STYPE(J:J).NE.' ') GO TO 120
 110  CONTINUE
 120  YLAB  = STYPE(:J) // ' - correction ' // UNITS
      TITLE = CTYPE // ':  CRVALk + w ' // UNITS
      CALL PGLAB('Pixel coordinate', YLAB, TITLE)

      CALL PGAXIS('N', 0.0, YMAX, REAL(NAXISJ), YMAX, XMIN, XMAX, 0.0,
     :        0, -0.5, 0.0, 0.5, -0.5, 0.0)

      CALL PGAXIS('N', REAL(NAXISJ), ymin, REAL(NAXISJ), YMAX,
     :        REAL(YMIN/CDELTS), REAL(YMAX/CDELTS), 0.0, 0, 0.5, 0.0,
     :        0.5, 0.1, 0.0)
      CALL PGMTXT('R', 2.2, 0.5, 0.5, 'Pixel offset')

      CALL PGLINE(NAXISJ, X, Y)
      CALL PGSCI(7)
      CALL PGPT1(REAL(CRPIXJ), 0.0, 24)
      CALL PGEBUF()

      WRITE (6, '($,A)') 'Type <RETURN> for next page: '
      READ (5, *, END=130)
 130  WRITE (6, *)

      RETURN
      END
