*=======================================================================
*
*   WCSLIB 3.5 - an implementation of the FITS WCS convention.
*   Copyright (C) 1995-2004, Mark Calabretta
*
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
*
*   This program is distributed in the hope that it will be useful, but
*   WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*   General Public License for more details.
*
*   You should have received a copy of the GNU General Public License
*   along with this library; if not, write to the Free Software
*   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*   Correspondence concerning WCSLIB may be directed to:
*      Internet email: mcalabre@atnf.csiro.au
*      Postal address: Dr. Mark Calabretta
*                      Australia Telescope National Facility, CSIRO
*                      PO Box 76
*                      Epping NSW 1710
*                      AUSTRALIA
*
*   Author: Mark Calabretta, Australia Telescope National Facility
*   http://www.atnf.csiro.au/~mcalabre/index.html
*   $Id: tpih1.f,v 3.5 2004/06/28 04:56:37 mcalabre Exp $
*=======================================================================

      PROGRAM TPIH1
*-----------------------------------------------------------------------
*
*   TPIH1 tests WCSPIH, the WCS FITS parser for image headers, by
*   reading a test header and using WCSPRT to print the resulting WCSPRM
*   structs.
*
*-----------------------------------------------------------------------

      INTEGER   ERRLVL, I, IERR, K, NKEYS, NREJECT, NWCS, RELAX, WCSP
      CHARACTER CARD*80, HEADER*28801, INFILE*8

      INCLUDE 'wcshdr.inc'
      INCLUDE 'wcs.inc'
      INTEGER WCS(WCSLEN)

      DATA INFILE /'wcs.fits'/
*-----------------------------------------------------------------------
      WRITE (6, 10)
 10   FORMAT (/,'Testing WCSLIB parser for FITS image headers',/,
     :          '--------------------------------------------',/)

*     Open the FITS WCS test header for formatted, direct I/O.
      OPEN (UNIT=1, FILE=INFILE, FORM='FORMATTED', ACCESS='DIRECT',
     :      RECL=80, IOSTAT=IERR)
      IF (IERR.NE.0) THEN
         WRITE (6, 20) IERR, INFILE
 20      FORMAT ('Error',I3,' opening ',A)
         GO TO 999
      END IF

*     Read in the header discarding COMMENT, &c. cards in the process.
      K = 1
      NKEYS = 0
      DO 40 I = 1, 360
         READ (1, '(A80)', REC=I, IOSTAT=IERR) CARD
         IF (IERR.NE.0) THEN
            WRITE (6, 30) IERR
 30         FORMAT ('Error',I3,' reading header.')
            GO TO 999
         END IF

         IF (CARD(:8).EQ.'        ') GO TO 40
         IF (CARD(:8).EQ.'COMMENT ') GO TO 40
         IF (CARD(:8).EQ.'HISTORY ') GO TO 40

         HEADER(K:) = CARD
         K = K + 80
         NKEYS = NKEYS + 1

         IF (CARD(:8).EQ.'END     ') GO TO 50
 40   CONTINUE
 50   HEADER(K:K) = CHAR (0)
      WRITE (6, 60) NKEYS
 60   FORMAT ('Found',I4,' non-comment keywords.')

      CLOSE (UNIT=1)


      RELAX  = 1
      ERRLVL = 3
*     WCSPIH will allocate memory for NWCS intialized WCSPRM structs.
      IERR = WCSPIH (HEADER, NKEYS, RELAX, ERRLVL, NREJECT, NWCS, WCSP)
      IF (IERR.NE.0) THEN
         WRITE (6, 70) IERR
 70      FORMAT ('WCSPIH error',I2)
         GO TO 999
      END IF

      DO 110 I = 0, NWCS-1
         WRITE (6, 80)
 80      FORMAT (/,'------------------------------------',
     :             '------------------------------------')

*        Copy into our WCSPRM struct (allocates memory).
         IERR = WCSVCOPY (WCSP, I, WCS)

         IERR = WCSSET (WCS)
         IF (IERR.NE.0) THEN
           WRITE (6, 90) IERR
 90        FORMAT ('WCSSET error',I2)
           GO TO 110
         END IF

         IERR = WCSPRT (WCS)
         IF (IERR.NE.0) THEN
           WRITE (6, 100) IERR
 100       FORMAT ('WCSPRT error',I2)
           GO TO 110
         END IF

*        Free the memory allocated by WCSVCOPY.
         IERR = WCSFREE (WCS)
 110  CONTINUE

*     Free the memory allocated by WCSPIH.
      IERR = WCSVFREE (NWCS, WCSP)

 999  CONTINUE
      END
