/*============================================================================
*
*   WCSLIB 3.6 - an implementation of the FITS WCS convention.
*   Copyright (C) 1995-2004, Mark Calabretta
*
*   This program is free software; you can redistribute it and/or modify it
*   under the terms of the GNU General Public License as published by the
*   Free Software Foundation; either version 2 of the License, or (at your
*   option) any later version.
*
*   This program is distributed in the hope that it will be useful, but
*   WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*   General Public License for more details.
*
*   You should have received a copy of the GNU General Public License along
*   with this library; if not, write to the Free Software Foundation, Inc.,
*   675 Mass Ave, Cambridge, MA 02139, USA.
*
*   Correspondence concerning WCSLIB may be directed to:
*      Internet email: mcalabre@atnf.csiro.au
*      Postal address: Dr. Mark Calabretta
*                      Australia Telescope National Facility, CSIRO
*                      PO Box 76
*                      Epping NSW 1710
*                      AUSTRALIA
*
*   Author: Mark Calabretta, Australia Telescope National Facility
*   http://www.atnf.csiro.au/~mcalabre/index.html
*   $Id: tpih1.c,v 3.6 2004/08/25 05:34:13 cal103 Exp $
*=============================================================================
*
*   tpih1 tests wcspih(), the WCS FITS parser for image headers, by reading a
*   test header and using wcsprt() to print the resulting wcsprm structs.
*
*---------------------------------------------------------------------------*/

#include <stdio.h>
#include <string.h>

#include <wcshdr.h>
#include <wcs.h>

int main(argc, argv)

int argc;
char *argv;

{
   char infile[] = "wcs.fits";
   char card[81], header[28801];
   int  i, k, nkeys, nreject, nwcs, relax, status;
   struct wcsprm *wcs;
   FILE *fptr;

   printf("\nTesting WCSLIB parser for FITS image headers\n"
          "--------------------------------------------\n\n");

   /* Open the FITS WCS test header. */
   if ((fptr = fopen(infile, "r")) == 0) {
      fprintf(stderr, "ERROR opening %s\n", infile);
      return 1;
   }

   /* Read in the header discarding COMMENT, &c. cards in the process. */
   k = 0;
   nkeys = 0;
   for (i = 0; i < 360; i++) {
      if (fgets(card, 81, fptr) == 0) {
         break;
      }

      if (strncmp(card, "        ", 8) == 0) continue;
      if (strncmp(card, "COMMENT ", 8) == 0) continue;
      if (strncmp(card, "HISTORY ", 8) == 0) continue;

      strncpy(header+k, card, 80);
      k += 80;
      nkeys++;

      if (strncmp(card, "END     ", 8) == 0) break;
   }
   fclose(fptr);

   fprintf(stderr, "Found %d non-comment keywords.\n", nkeys);

   relax = WCSHDR_all;
   if (status = wcspih(header, nkeys, relax, 3, &nreject, &nwcs, &wcs)) {
      fprintf(stderr, "wcspih ERROR %d, %s.\n", status, wcs_errmsg[status]);
   }

   for (i = 0; i < nwcs; i++) {
      printf("\n------------------------------------"
           "------------------------------------\n");
      if (status = wcsset(wcs+i)) {
         fprintf(stderr, "wcsset ERROR %d, %s.\n", status,
                 wcs_errmsg[status]);
         continue;
      }

      if (status = wcsprt(wcs+i)) {
         fprintf(stderr, "wcsprt ERROR %d, %s.\n", status,
                 wcs_errmsg[status]);
      }
   }

   status = wcsvfree(&nwcs, &wcs);

   return 0;
}
