/*============================================================================
*
*   WCSLIB 3.6 - an implementation of the FITS WCS convention.
*   Copyright (C) 1995-2004, Mark Calabretta
*
*   This library is free software; you can redistribute it and/or modify it
*   under the terms of the GNU Library General Public License as published
*   by the Free Software Foundation; either version 2 of the License, or (at
*   your option) any later version.
*
*   This library is distributed in the hope that it will be useful, but
*   WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library
*   General Public License for more details.
*
*   You should have received a copy of the GNU Library General Public License
*   along with this library; if not, write to the Free Software Foundation,
*   Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*   Correspondence concerning WCSLIB may be directed to:
*      Internet email: mcalabre@atnf.csiro.au
*      Postal address: Dr. Mark Calabretta
*                      Australia Telescope National Facility, CSIRO
*                      PO Box 76
*                      Epping NSW 1710
*                      AUSTRALIA
*
*   Author: Mark Calabretta, Australia Telescope National Facility
*   http://www.atnf.csiro.au/~mcalabre/index.html
*   $Id: wcshdr_f.c,v 3.6 2004/08/24 08:31:49 cal103 Exp $
*===========================================================================*/

#include <wcshdr.h>
#include <wcs.h>

/*--------------------------------------------------------------------------*/

int wcspih_(header, nkeys, relax, errlvl, nreject, nwcs, wcsp)

char *header;
const int *nkeys, *relax, *errlvl;
int *nreject, *nwcs, *wcsp;

{
   return wcspih(header, *nkeys, *relax, *errlvl, nreject, nwcs,
      (struct wcsprm **)wcsp);
}

/*--------------------------------------------------------------------------*/

int wcsvcopy_(wcspp, i, wcs)

const int *wcspp, *i;
int *wcs;

{
   return wcscopy(1, *((struct wcsprm **)wcspp) + *i, (struct wcsprm *)wcs);
}

/*--------------------------------------------------------------------------*/

int wcsvfree_(nwcs, wcspp)

int *nwcs, *wcspp;

{
   return wcsvfree(nwcs, (struct wcsprm **)wcspp);
}
