/*============================================================================
*
*   WCSLIB 4.0 - an implementation of the FITS WCS convention.
*   Copyright (C) 1995-2005, Mark Calabretta
*
*   WCSLIB is free software; you can redistribute it and/or modify it under
*   the terms of the GNU General Public License as published by the Free
*   Software Foundation; either version 2 of the License, or (at your option)
*   any later version.
*
*   WCSLIB is distributed in the hope that it will be useful, but WITHOUT ANY
*   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
*   FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
*   details.
*
*   You should have received a copy of the GNU General Public License along
*   with WCSLIB; if not, write to the Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA  02111-1307, USA
*
*   Correspondence concerning WCSLIB may be directed to:
*      Internet email: mcalabre@atnf.csiro.au
*      Postal address: Dr. Mark Calabretta
*                      Australia Telescope National Facility, CSIRO
*                      PO Box 76
*                      Epping NSW 1710
*                      AUSTRALIA
*
*   Author: Mark Calabretta, Australia Telescope National Facility
*   http://www.atnf.csiro.au/~mcalabre/index.html
*   $Id: tpih2.c,v 4.0 2005/02/04 06:31:21 cal103 Exp $
*=============================================================================
*
*   tpih2 tests wcspih(), the WCS FITS parser for image headers, by reading a
*   test header and using pgsbox() to plot coordinate graticules for the
*   resulting wcsprm structs.
*
*---------------------------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <fitsio.h>
#include <cpgplot.h>
#include <cpgsbox.h>
#include <wcshdr.h>
#include <wcs.h>

int main(argc, argv)

int argc;
char *argv;

{
   char infile[] = "wcs.fits";
   char devtyp[16], *header, idents[3][80], nlcprm[1], opt[2];
   int  c0[] = {-1, -1, -1, -1, -1, -1, -1};
   int  i, ic, gcode[2], naxis[2], nkeys, nreject, nwcs, relax, status;
   float  blc[2], trc[2];
   double cache[257][4], grid1[9], grid2[9], nldprm[1];
   struct wcsprm *wcs;
   fitsfile *fptr;
   nlfunc_t pgwcsl_;

   printf("\nTesting WCSLIB parser for FITS image headers\n"
          "--------------------------------------------\n\n");

   status = 0;
   if (fits_open_file(&fptr, infile, READONLY, &status)) {
      fits_report_error(stderr, status);
      return 1;
   }
   if (fits_hdr2str(fptr, 1, NULL, 0, &header, &nkeys, &status)) {
      fits_report_error(stderr, status);
      return 1;
   }
   fits_close_file(fptr, &status);

   fprintf(stderr, "Found %d non-comment keywords.\n", nkeys);

   relax = WCSHDR_all;
   if (status = wcspih(header, nkeys, relax, 3, &nreject, &nwcs, &wcs)) {
      fprintf(stderr, "wcspih ERROR %d, %s.\n", status, wcs_errmsg[status]);
   }

   /* Plot setup. */
   naxis[0] = 1024;
   naxis[1] = 1024;

   blc[0] = 0.5f;
   blc[1] = 0.5f;
   trc[0] = naxis[0] + 0.5f;
   trc[1] = naxis[1] + 0.5f;

   strcpy(devtyp, "/XWINDOW");
   cpgbeg(0, devtyp, 1, 1);
   cpgvstd();

   cpgwnad(0.0f, 1.0f, 0.0f, 1.0f);
   cpgask(1);
   cpgpage();

   /* Annotation. */
   strcpy(idents[0], "Right ascension");
   strcpy(idents[1], "Declination");

   opt[0] = 'G';
   opt[1] = 'E';

   /* Compact lettering. */
   cpgsch(0.8f);

   /* Draw full grid lines. */
   cpgsci(1);
   gcode[0] = 2;
   gcode[1] = 2;
   grid1[0] = 0.0;
   grid2[0] = 0.0;

   for (i = 0; i < nwcs; i++) {
      if (status = wcsset(wcs+i)) {
         fprintf(stderr, "wcsset ERROR %d, %s.\n", status,
                 wcs_errmsg[status]);
         continue;
      }

      /* Get WCSNAME out of the wcsprm struct. */
      strcpy(idents[2], (wcs+i)->wcsname);
      printf("\n%s\n", idents[2]);

      /* Draw the celestial grid.  The grid density is set for each world */
      /* coordinate by specifying LABDEN = 1224. */
      ic = -1;
      cpgsbox(blc, trc, idents, opt, 0, 1224, c0, gcode, 0.0, 0, grid1, 0,
         grid2, 0, pgwcsl_, 1, WCSLEN, 1, nlcprm, (int *)(wcs+i), nldprm, 256,
         &ic, cache, &status);

      /* Draw the frame. */
      cpgbox("BC", 0.0f, 0, "BC", 0.0f, 0);

      cpgpage();
   }

   status = wcsvfree(&nwcs, &wcs);
   free(header);

   return 0;
}
