/*============================================================================
*
*   WCSLIB 4.0 - an implementation of the FITS WCS convention.
*   Copyright (C) 1995-2005, Mark Calabretta
*
*   WCSLIB is free software; you can redistribute it and/or modify it under
*   the terms of the GNU General Public License as published by the Free
*   Software Foundation; either version 2 of the License, or (at your option)
*   any later version.
*
*   WCSLIB is distributed in the hope that it will be useful, but WITHOUT ANY
*   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
*   FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
*   details.
*
*   You should have received a copy of the GNU General Public License along
*   with WCSLIB; if not, write to the Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA  02111-1307, USA
*
*   Correspondence concerning WCSLIB may be directed to:
*      Internet email: mcalabre@atnf.csiro.au
*      Postal address: Dr. Mark Calabretta
*                      Australia Telescope National Facility, CSIRO
*                      PO Box 76
*                      Epping NSW 1710
*                      AUSTRALIA
*
*   Author: Mark Calabretta, Australia Telescope National Facility
*   http://www.atnf.csiro.au/~mcalabre/index.html
*   $Id: wcshdr_f.c,v 4.0 2005/02/04 12:40:07 cal103 Exp $
*===========================================================================*/

#include <wcshdr.h>
#include <wcs.h>

/*--------------------------------------------------------------------------*/

int wcsidx_(int *nwcs, int *wcsp, int alts[27])

{
   return wcsidx(*nwcs, (struct wcsprm **)wcsp, alts);
}

/*--------------------------------------------------------------------------*/

int wcspih_(char *header, const int *nkeys, const int *relax,
            const int *errlvl, int *nreject, int *nwcs, int *wcsp)

{
   return wcspih(header, *nkeys, *relax, *errlvl, nreject, nwcs,
      (struct wcsprm **)wcsp);
}

/*--------------------------------------------------------------------------*/

int wcsvcopy_(const int *wcspp, const int *i, int *wcs)

{
   return wcscopy(1, *((struct wcsprm **)wcspp) + *i, (struct wcsprm *)wcs);
}

/*--------------------------------------------------------------------------*/

int wcsvfree_(int *nwcs, int *wcspp)

{
   return wcsvfree(nwcs, (struct wcsprm **)wcspp);
}
