/*============================================================================

  WCSLIB 4.4 - an implementation of the FITS WCS standard.
  Copyright (C) 1995-2009, Mark Calabretta

  This file is part of WCSLIB.

  WCSLIB is free software: you can redistribute it and/or modify it under the
  terms of the GNU Lesser General Public License as published by the Free
  Software Foundation, either version 3 of the License, or (at your option)
  any later version.

  WCSLIB is distributed in the hope that it will be useful, but WITHOUT ANY
  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
  FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
  more details.

  You should have received a copy of the GNU Lesser General Public License
  along with WCSLIB.  If not, see <http://www.gnu.org/licenses/>.

  Correspondence concerning WCSLIB may be directed to:
    Internet email: mcalabre@atnf.csiro.au
    Postal address: Dr. Mark Calabretta
                    Australia Telescope National Facility, CSIRO
                    PO Box 76
                    Epping NSW 1710
                    AUSTRALIA

  Author: Mark Calabretta, Australia Telescope National Facility
  http://www.atnf.csiro.au/~mcalabre/index.html
  $Id: wcslib.h,v 4.4 2009/08/06 07:41:33 cal103 Exp $
*=============================================================================
*
* WCSLIB 4.4 - C routines that implement the FITS World Coordinate System
* (WCS) standard.
*
* Summary of wcslib.h
* -------------------
* This header file is provided purely for convenience.  Use it to include all
* of the separate WCSLIB headers.
*
*===========================================================================*/

#ifndef WCSLIB_WCSLIB
#define WCSLIB_WCSLIB

#include "cel.h"
#include "fitshdr.h"
#include "lin.h"
#include "log.h"
#include "prj.h"
#include "spc.h"
#include "sph.h"
#include "spx.h"
#include "tab.h"
#include "wcs.h"
#include "wcsfix.h"
#include "wcshdr.h"
#include "wcsmath.h"
#include "wcstrig.h"
#include "wcsunits.h"
#include "wcsutil.h"

#endif /* WCSLIB_WCSLIB */
