*=======================================================================
*
* WCSLIB 5.1 - an implementation of the FITS WCS standard.
* Copyright (C) 1995-2015, Mark Calabretta
*
* This file is part of WCSLIB.
*
* WCSLIB is free software: you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as published
* by the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* WCSLIB is distributed in the hope that it will be useful, but WITHOUT
* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
* FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
* License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with WCSLIB.  If not, see http://www.gnu.org/licenses.
*
* Direct correspondence concerning WCSLIB to mark@calabretta.id.au
*
* Author: Mark Calabretta, Australia Telescope National Facility, CSIRO.
* http://www.atnf.csiro.au/people/Mark.Calabretta
* $Id: dis.inc,v 5.1 2015/04/07 10:56:38 mcalabre Exp $
*=======================================================================

*     Functions.
      EXTERNAL  DISALLOC,
     :          DISPUT, DISPTC,   DISPTD, DISPTI,
     :          DISGET, DISGTC,   DISGTD, DISGTI,
     :          DISINI, DISPARMS, DISCPY, DISFREE, DISPRT, DISPERR,
     :          DISSET, DISP2X,   DISX2P, DISWARP

      INTEGER   DISALLOC,
     :          DISPUT, DISPTC,   DISPTD, DISPTI,
     :          DISGET, DISGTC,   DISGTD, DISGTI,
     :          DISINI, DISPARMS, DISCPY, DISFREE, DISPRT, DISPERR,
     :          DISSET, DISP2X,   DISX2P, DISWARP

*     Length of the DISPRM data structure (INTEGER array) on 64-bit
*     machines.  Only needs to be 28 on 32-bit machines.
      INTEGER   DISLEN
      PARAMETER (DISLEN = 48)

*     Codes for DIS data structure elements used by DISPUT and DISGET.
      INTEGER   DIS_FLAG, DIS_NAXIS, DIS_DTYPE, DIS_AXMAP, DIS_OFFSET,
     :          DIS_SCALE, DIS_NPARM, DIS_PARMS, DIS_MAXDIS, DIS_TOTDIS

      PARAMETER (DIS_FLAG   = 100)
      PARAMETER (DIS_NAXIS  = 101)
      PARAMETER (DIS_DTYPE  = 102)
      PARAMETER (DIS_AXMAP  = 103)
      PARAMETER (DIS_OFFSET = 104)
      PARAMETER (DIS_SCALE  = 105)
      PARAMETER (DIS_NPARM  = 106)
      PARAMETER (DIS_PARMS  = 107)
      PARAMETER (DIS_MAXDIS = 108)
      PARAMETER (DIS_TOTDIS = 109)

*     Codes for DIS data structure elements used by DISGET (only).
      INTEGER   DIS_ERR

      PARAMETER (DIS_ERR    = 201)

*     Error codes and messages.
      INTEGER   DISERR_SUCCESS, DISERR_NULL_POINTER, DISERR_MEMORY,
     :          DISERR_DISTORT_INIT, DISERR_DISTORT, DISERR_DEDISTORT

      PARAMETER (DISERR_SUCCESS      = 0)
      PARAMETER (DISERR_NULL_POINTER = 1)
      PARAMETER (DISERR_MEMORY       = 2)
      PARAMETER (DISERR_DISTORT_INIT = 3)
      PARAMETER (DISERR_DISTORT      = 4)
      PARAMETER (DISERR_DEDISTORT    = 5)

      CHARACTER DIS_ERRMSG(0:5)*80
      COMMON /DIS_DATA/ DIS_ERRMSG
